#include "mbed.h"

SPI Spi(P10_14, P10_15, P10_12);
DigitalOut Cs(P10_13, 1);

#define CTL_REG_1   (0x44)

void KXG03Write(uint8_t address, const uint8_t* payload, int payloadSize)
{
    Cs = 0;
    wait_us(1);
    Spi.write(address & ~0x80);
    while (payloadSize--)
    {
        Spi.write(*payload++);
    }
    wait_us(1);
    Cs = 1;
    wait_us(1);
}

void KXG03Read(uint8_t address, uint8_t* payload, int payloadSize)
{
    Cs = 0;
    wait_us(1);
    Spi.write(address | 0x80);
    while (payloadSize--)
    {
        *payload++ = Spi.write(0);
    }
    wait_us(1);
    Cs = 1;
    wait_us(1);
}

int main()
{
    wait_ms(1000);
    
    uint8_t data;
    KXG03Read(CTL_REG_1, &data, sizeof (data));
    
    data |= 0x20;
    KXG03Write(CTL_REG_1, &data, sizeof (data));
    
    KXG03Read(CTL_REG_1, &data, sizeof (data));
}
