#include "mbed.h"

#define SENSOR_NUMBER 3

Serial device(USBTX, USBRX);  // tx, rx

DigitalOut myLed1(LED1);
DigitalOut myLed2(LED2);
DigitalOut myLed3(LED3);

AnalogIn ain1(p15);
AnalogIn ain2(p16);
AnalogIn ain3(p17);
AnalogIn ain4(p18);
AnalogIn ain5(p19);
AnalogIn ain6(p20);

I2C i2c(p9,p10);

void getInit(void);
void sendData(void);

typedef struct{
    int id;
    int analogNumber;
    int length;
}sensor_t;
sensor_t sensor[SENSOR_NUMBER];


int main() {
    device.baud(115200);
    /*
    i2c.frequency(40000);
    char cmd[6];
    char add[1];
    char init[2];
    add[0] = 0x01;
    init[0] = 0x2A;
    init[1] = 0x01;
    while(i2c.write(0x3A,init,2));
    */

    myLed1 = 0;
    myLed2 = 0;
    myLed3 = 0;    

    getInit();
    myLed1 = 1;
    sendData();

}


void getInit()
{
    int valueNumber = 0;
    int getValue = 0;
    int sensorCount = 0;
    int allSensorData = 1;
    
    while(1){
        if(device.readable()){
            valueNumber++;
            getValue = device.getc();
            switch(valueNumber){
            case 1:
                allSensorData = getValue;
                break;
            case 2:
                sensor[sensorCount/3].id = getValue;
                sensorCount++;
                break;
            case 3:
                sensor[(sensorCount-1)/3].analogNumber = getValue;
                sensorCount++;
                break;
            case 4:
                sensor[(sensorCount-2)/3].length = getValue;                
                sensorCount++;
                valueNumber = 1;
                break;
            } 
        }
        if(sensorCount > allSensorData-1)break;        
    }
}

void sendData()
{
    int valueNumber = 0;
    int id = 0;
    int getValue = 0;
    int checkSum = 0;
    int analogNumberTill = 0;
    int analogNumber = 0;
    char sendData[8];
    int analogData[10] = {0};

    while(1){
        if(device.readable()){
            valueNumber++;
            getValue = device.getc();                        
            switch(valueNumber){
                case 1: //get ID
                    id = getValue;
                    sendData[0] = id;
                    break;
                case 2:                     //get analog data
                    analogData[0] = ain1.read_u16();
                    analogData[1] = ain2.read_u16();
                    analogData[2] = ain3.read_u16();
                    analogData[3] = ain4.read_u16();
                    analogData[4] = ain5.read_u16();
                    analogData[5] = ain6.read_u16();

                    //calc which data to get
                    for(int i=0; i<id; i++){
                        analogNumberTill += sensor[i].analogNumber;
                    }
                    
                    if(getValue == 0xFE){
                        analogNumber = sensor[id].analogNumber;                        
                    }else{
                        analogNumber = 1;
                    }
                    
                    //analog data to send
                    for(int i=0; i<analogNumber; i++){
                        if(sensor[id].length == 2){
                             sendData[i*2+1] = analogData[i+analogNumberTill] >> 8;
                             sendData[i*2+2] = analogData[i+analogNumberTill] & 0xFF;
                        }else if(sensor[id].length == 1){
                             sendData[i+1] = analogData[i+analogNumberTill] & 0xFF;                        
                        }
                    }
                    
                    //senddata
                    for(int i=0; i < sensor[id].length*analogNumber+1; i++){
                        device.putc(sendData[i]);
                        checkSum += sendData[i];
                    }
                    device.putc(checkSum & 0xFF);
                    
                    checkSum = 0;
                    valueNumber = 0;
                    analogNumberTill = 0;
                    id = 0;
                    analogNumber = 0;
                    
                    break;
            }
        }
    }
}