#include "command.h"
#include "mbed.h"





Command::Command(PinName pin) :Servo(pin)
{
    _power = true;
};

void Command::targetPosition(int number ,int receive)
{
    switch(number-3){
        case 0:
            _position = receive<<8;
            break;
        case 1:
            _position += receive;
            break;
        case 2:
            _time = receive<<8;
            break;
        case 3:
            _time += receive;
            break;
   }

}

void Command::homePosition(int number ,int receive)
{
   switch(number-3){
        case 0:
            _position = receive<<8;
            break;
        case 1:
            _position += receive;
            break;
        case 2:
            _homePosition = _position;
            break;
   }
}


int Command::getPosition()
{
    return _position;
}

int Command::getTime()
{
    return _time;
}

int Command::getHomeposition()
{
    return _homePosition;
}

bool Command::getPower()
{
    return _power;
}

void Command::on()
{
    write(getPosition()/1800);
    _power = true;
}

void Command::off()
{
    _pwm.pulsewidth(0);
    _power = false;
}

Command& Command::operator= (float percent) {
    if(getPower() == true)
        write(percent);
    return *this;
}

Command& Command::operator= (Command& rhs) {
    if(getPower() == true)
        write(rhs.read());
    return *this;
}

