#ifndef PAW_H
#define PAW_H

#include "mbed.h"

#define STATE_1 0
#define STATE_2 1
#define STATE_3 2
#define STATE_4 3

struct paw_value
{
    public: 
        short ch_1;
        short ch_2;
        short ch_3;
        short ch_4;
        short initial_photo_1;
        short initial_photo_2;
        
        paw_value()
            {
                ch_1 = 0;
                ch_2 = 0;
                ch_3 = 0;
                ch_4 = 0;
                initial_photo_1 = 0;
                initial_photo_2 = 0;
            }
};

/** PAW_Sensor Library
 *
 * Example:
 * @code
 * 
#include "mbed.h"
#include "paw.h"

Serial pc( USBTX, USBRX ); 
const unsigned long baudrate = 115200;

// paw( LED1, LED2, PHOTO1, PHOTO2 )
PAW paw( p8, p9, p16, p17 );
paw_value g_value;

Ticker run;


void run_paw_sensor()
{
    if( paw.process_paw() == STATE_1 )
    {
        paw.print( &pc, 0 );   
    }
}

int main() 
{
    // Initializing Serial Communication
    pc.baud( baudrate );
    pc.format( 8, Serial::None, 1 );
    
    run.attach_us(&run_paw_sensor, 500);
    
    while(1);
}

 * @endcode
 */

class PAW {
    
    public:
    
        /** Create a PAW Sensor instance
         *
         * @param led_1 PAW Sensor's Pin 5
         * @param led_2 PAW Sensor's Pin 4
         * @param photo_1 PAW Sensor's Pin 3
         * @param photo_2 PAW Sensor's Pin 2
         */ 
        PAW( PinName led_1, PinName led_2, PinName photo_1, PinName photo_2 );
        
        /** Get values of PAW Sensor
         *
         * @return Return values of photosensor's voltage.
         */ 
        paw_value get_value();
        
        /** Processing of Paw sensor. This fucntion must be performed periodically.
         *
         * @return Return current processing-state.
         */ 
        unsigned char process_paw();
        
        /** Get current processing-state.
         *
         * @return Return current processing-state.
         */ 
        bool get_state();
        
        /** Send values of PAW Sensor through serial-communication.
         *
         * @param Reference to serial object.
         * @param ID of PAW Sensor. you can chose number from 0 to 255.
         */ 
        void print( Serial* pc, unsigned char id );
        
    protected:
        DigitalOut _led_1;
        DigitalOut _led_2;
        AnalogIn   _photo_1;
        AnalogIn   _photo_2;
        
        unsigned char _state;
        
        paw_value _value;
};

#endif /*** PAW_H ***/