/* mbed PAW_Sensor Library
 *
 * paw.cpp
 *
 * Copyright (c) 2014 Hiroaki Matsuda
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "paw.h"

PAW::PAW( PinName led_1, PinName led_2, PinName photo_1, PinName photo_2 ):
        _led_1( led_1 ), _led_2( led_2 ), _photo_1( photo_1 ), _photo_2( photo_2 ){

    _led_1 = 0;
    _led_2 = 0;
    _state = STATE_1;
}

unsigned char PAW::process_paw()
{
    switch( _state )
    {
        case STATE_1:
            _value.initial_photo_1 = _photo_1.read_u16();
            _value.initial_photo_2 = _photo_2.read_u16();
            _led_1 = 1;
            
            _state = STATE_2;
            break;
            
        case STATE_2:
            _value.ch_3 = ( _photo_1.read_u16() - _value.initial_photo_1 ) >> 4;
            _value.ch_4 = ( _photo_2.read_u16() - _value.initial_photo_2 ) >> 4;
            _led_1 = 0;
            
            _state = STATE_3;
            break;
            
        case STATE_3:
            _value.initial_photo_1 = _photo_1.read_u16();
            _value.initial_photo_2 = _photo_2.read_u16();
            _led_2 = 1;
            
            _state = STATE_4;
            break;
            
        case STATE_4:
            _value.ch_2 = ( _photo_1.read_u16() - _value.initial_photo_2 ) >> 4;
            _value.ch_1 = ( _photo_2.read_u16() - _value.initial_photo_1 ) >> 4;
            _led_2 = 0;
            
            _state = STATE_1;                                                               
            break;
    }
    
    return _state;
}

paw_value PAW::get_value()
{
    return _value;
}

bool PAW::get_state()
{
    return _state;
}

void PAW::print( Serial* pc )
{
    pc->printf("%c%c%c%c%c%c%c%c%c%c", 0xFA, 0xAF, 
                                           _value.ch_1 & 0x00FF, ( _value.ch_1 & 0xFF00 ) >> 8,
                                           _value.ch_2 & 0x00FF, ( _value.ch_2 & 0xFF00 ) >> 8,
                                           _value.ch_3 & 0x00FF, ( _value.ch_3 & 0xFF00 ) >> 8,
                                           _value.ch_4 & 0x00FF, ( _value.ch_4 & 0xFF00 ) >> 8);
}
    
