#include "paw.h"

PAW::PAW( PinName led_1, PinName led_2, PinName photo_1, PinName photo_2 ):
        _led_1( led_1 ), _led_2( led_2 ), _photo_1( photo_1 ), _photo_2( photo_2 ){

    _led_1 = 0;
    _led_2 = 0;
    _state = STATE_1;
}

unsigned char PAW::process_paw()
{
    switch( _state )
    {
        case STATE_1:
            _value.initial_photo_1 = _photo_1.read_u16();
            _value.initial_photo_2 = _photo_2.read_u16();
            _led_1 = 1;
            
            _state = STATE_2;
            break;
            
        case STATE_2:
            _value.ch_3 = ( _photo_1.read_u16() - _value.initial_photo_1 ) >> 4;
            _value.ch_4 = ( _photo_2.read_u16() - _value.initial_photo_2 ) >> 4;
            _led_1 = 0;
            
            _state = STATE_3;
            break;
            
        case STATE_3:
            _value.initial_photo_1 = _photo_1.read_u16();
            _value.initial_photo_2 = _photo_2.read_u16();
            _led_2 = 1;
            
            _state = STATE_4;
            break;
            
        case STATE_4:
            _value.ch_2 = ( _photo_1.read_u16() - _value.initial_photo_2 ) >> 4;
            _value.ch_1 = ( _photo_2.read_u16() - _value.initial_photo_1 ) >> 4;
            _led_2 = 0;
            
            _state = STATE_1;                                                               
            break;
    }
    
    return _state;
}

paw_value PAW::get_value()
{
    return _value;
}

bool PAW::get_state()
{
    return _state;
}

void PAW::print( Serial* pc )
{
    pc->printf("%c%c%c%c%c%c%c%c%c%c", 0xFA, 0xAF, 
                                           _value.ch_1 & 0x00FF, ( _value.ch_1 & 0xFF00 ) >> 8,
                                           _value.ch_2 & 0x00FF, ( _value.ch_2 & 0xFF00 ) >> 8,
                                           _value.ch_3 & 0x00FF, ( _value.ch_3 & 0xFF00 ) >> 8,
                                           _value.ch_4 & 0x00FF, ( _value.ch_4 & 0xFF00 ) >> 8);
}
    
