#include "mbed.h"
#include "platform/mbed_thread.h"
#include "C12832.h"
#include "pitchs_copy.h"
#include "LM75B.h"

#define do 261
#define re 293
#define mi 329

LM75B sensor(D14, D15);

DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
DigitalIn right(A5);
DigitalIn center(D4);

C12832 lcd(D11, D13, D12, D7, D10);
PwmOut buzzer(D6);
enum {MARIO,AUCLAIR,MUSIQUE,TEMP} etat = MUSIQUE ;
int melodie[]=
{do, do, do,re,mi,re,do,mi,re,re,do};
int temps[]= {4,4,4,4,2,3,4,4,4,4,2};
char message_precedent[]="            ";
int menu_precedent = AUCLAIR;

int melody[] = {
    NOTE_E7, NOTE_E7, 1, NOTE_E7,
    1, NOTE_C7, NOTE_E7, 1,
    NOTE_G7, 1, 1,  1,
    NOTE_G6, 1, 1, 1,

    NOTE_C7, 1, 1, NOTE_G6,
    1, 1, NOTE_E6, 1,
    1, NOTE_A6, 1, NOTE_B6,
    1, NOTE_AS6, NOTE_A6, 1,

    NOTE_G6, NOTE_E7, NOTE_G7,
    NOTE_A7, 1, NOTE_F7, NOTE_G7,
    1, NOTE_E7, 1,NOTE_C7,
    NOTE_D7, NOTE_B6, 1, 1,

    NOTE_C7, 1, 1, NOTE_G6,
    1, 1, NOTE_E6, 1,
    1, NOTE_A6, 1, NOTE_B6,
    1, NOTE_AS6, NOTE_A6, 1,

    NOTE_G6, NOTE_E7, NOTE_G7,
    NOTE_A7, 1, NOTE_F7, NOTE_G7,
    1, NOTE_E7, 1,NOTE_C7,
    NOTE_D7, NOTE_B6, 1, 1
};
int noteDurations[] = {
    12, 12, 12, 12,
    12, 12, 12, 12,
    12, 12, 12, 12,
    12, 12, 12, 12,
    12, 12, 12, 12,
    12, 12, 12, 12,
    12, 12, 12, 12,
    12, 12, 12, 12,
    9, 9, 9,
    12, 12, 12, 12,
    12, 12, 12, 12,
    12, 12, 12, 12,
    12, 12, 12, 12,
    12, 12, 12, 12,
    12, 12, 12, 12,
    12, 12, 12, 12,
    9, 9, 9,
    12, 12, 12, 12,
    12, 12, 12, 12,
    12, 12, 12, 12,
};

void mario()
{
    int size = sizeof(melody) / sizeof(int);
    for (int thisNote = 0; thisNote < 52; thisNote++) {
        int noteDuration = noteDurations[thisNote];
        buzzer.period(1.0/melody[thisNote]);
        buzzer=0.25;
        wait(1.0/noteDuration);
        int pauseBetweenNotes = noteDuration * 1.30;
        wait(1.0/pauseBetweenNotes);
        buzzer=0;
    }
}


void auclair()
{
    int size = sizeof(melodie) / sizeof(int);

    for (int thisNote = 0; thisNote < 11; thisNote++) {
        int noteDuration = temps[thisNote];
        buzzer.period(1.0/melodie[thisNote]);
        buzzer=0.25;
        wait(1.0/noteDuration);
        int pauseBetweenNotes = noteDuration * 1.30;
        wait(1.0/pauseBetweenNotes);
        buzzer=0;

    }
}

void Afficher_Menu(int Menu)
{
    if (menu_precedent == Menu) return;
    menu_precedent = Menu;
    lcd.cls();
    lcd.locate(0,8);
    switch(Menu) {
        case MUSIQUE :
            lcd.printf("Musique:");
            break;
        case MARIO :
            lcd.printf("Mario :");
            // mario();
            break;
        case AUCLAIR :
            lcd.printf("Au clair de la lune :");
            // auclair();
            break;
        case TEMP :
            lcd.printf("température:");
            // auclair();
            break;
    }
}

int main()
{
    while (1) {
        /*  while(!center) {
              wait(0.1);
          }*/
        Afficher_Menu(etat);
        switch (etat) {
            case MUSIQUE :
                // évèments
                if (down) etat = MARIO;
                if(up) etat = TEMP;
                break;
            case MARIO :
                if (down) etat = AUCLAIR;
                if (right) mario();
                if (up) etat = MUSIQUE;
                break;
            case AUCLAIR :
                if (up) etat = MARIO;
                if(right) auclair();
                if(down) etat = TEMP;
                break;
            case TEMP :
                if (up) etat = AUCLAIR;
                if(down) etat = MUSIQUE;
                lcd.cls();
                lcd.locate(0,8);
                lcd.printf("Temp = %.3f\n", sensor.temp());
                wait(0.5);
                break;
        }
        wait(0.125);

    }
}
