/****** R/C to Ethernet Signal Converter feat.I2C *******/
/******                  Ver. 1.0                 *******/
/******            Written by Wada Suisei         *******/
/******                 2017 Oct 1                *******/
//
// Modified on Oct.20th, 2017  by Mato Hattori
//

/*** Including Header Files***/
#include "mbed.h"
#include "EthernetInterface.h"

/*** Ethernet Configuration data***/
const char IpAddr[] = "192.168.11.241";
const char NetMask[] = "255.255.255.0";
const char GatewayAddr[] = "192.168.11.1";
const int Port_Num = 4001;

const char MotorDriverIpAddr[] = "192.168.11.242";   // motor driver ip address
const int MotorDriverPortNum = 4000;               // motor driver ip port

/*** I2C Configure***/
#define SDA_PIN p28
#define SCL_PIN p27
#define SLAVE_NUMBER 3
#define MSEC    /1000.0
#define LOOP_INTERVAL_MILISEC   500   // loop interval in mili-seconds 
const int SlaveAddr[SLAVE_NUMBER] = {0x0b, 0x0c, 0x0d};
const int min_cnt[SLAVE_NUMBER] ={1119,1650,1650};/*1ch:SW, 2ch:Rudder, 5ch:Thrustor*/
const int max_cnt[SLAVE_NUMBER] ={1960, 2915,2915};/*1ch:SW, 2ch:Rudder, 5ch:Thrustor*/

/***Pin Mode Initializing***/
int pin_init(void){
    return 1;
}


int main(){
    
    /*Pin Init*/
    pin_init();
    printf("Pin Initialize Complete!\n");
    
    /*I2C Init*/
    I2C i2c_master(SDA_PIN, SCL_PIN);
    printf("I2C Initialize Complete!\n");
    
    /*Ethernet Init*/
    EthernetInterface eth;
    if(eth.init(IpAddr, NetMask, GatewayAddr)){
        return -1;
    }
    eth.connect();
    printf("Ethernet Connected\n");
    printf("------------------------------\n");
    printf("IP Address is %s\n",eth.getIPAddress());
    printf("Net Mask is %s\n",eth.getNetworkMask());
    printf("------------------------------\n");
    
    /*UDP Init*/
    UDPSocket sock;
    sock.bind(Port_Num);
    
    /*Endpoint Init*/
    Endpoint md;
    md.set_address (MotorDriverIpAddr, MotorDriverPortNum);
    
    
    /**Main Routine**/
    int  udpout_buffer[3];
    int  udpin_buffer[3];
    int  data_int[SLAVE_NUMBER];
    int  data_ratio[SLAVE_NUMBER];
    int  seq;
    long tick = 0;
    DigitalOut  myled (LED1);
    
    myled = 0; // turn off LED1
    
    while(1){

        /*i2c Initialize*/        
        printf("I2C Data fetch.....  ");
        
        /*i2c communication sequence*/
        for(seq=0; seq<SLAVE_NUMBER; seq++)
        {    
            data_int[seq] = 0;
            /*data_frac[seq] = 0;*/
#if 0            
            i2c_master.start();  /*Send start condition*/
            while(i2c_master.read( ((SlaveAddr[seq]<<1)|0x01), receive_data, sizeof(receive_data) )); /*Wait ACK  --Master Receive*/
            i2c_master.stop();

            /*Value Modification Sequence*/           
            data_int[seq] = ( (receive_data[0]<<8)| receive_data[1] );
            data_ratio[seq] = (data_int[seq] - min_cnt[seq])*200/(max_cnt[seq] - min_cnt[seq])-100;
#else
            AnalogIn vr (p18);          // DEBUG for testing 
            if (! seq)
                printf ("ain=%f ", (float) vr);
            data_ratio[seq] = (int)(( (float) vr - 0.527) * 277.0);
#endif  

            if(-5<=data_ratio[seq] && data_ratio[seq]<=5){
                data_ratio[seq] = 0;
            }else if(data_ratio[seq]<=-96){
                data_ratio[seq] = -100;
            }else if(data_ratio[seq]>=96){
                data_ratio[seq] = 100;
            }
            
            printf("%d%% (0x%02x)   ", data_ratio[seq], SlaveAddr[seq]);
        }
        printf("\n");
 
        // UDP Communication Sequence        
        //for(seq=0; seq<SLAVE_NUMBER; seq++)
        //    udpout_buffer[seq] = data_ratio[seq];
        udpout_buffer[0] = data_ratio[0];
        udpout_buffer[1] = 0;
        
        printf("tx -> #%ld : %d %d\n", tick, udpout_buffer[0], udpout_buffer[1]);
        sock.sendTo(md, (char *)udpout_buffer, 4);
 
//        memset (udpin_buffer, sizeof (udpin_buffer), 0);
//        sock.receiveFrom (md, (char *)udpin_buffer, sizeof (udpin_buffer));
//        printf("rx <- #%ld : %d %d %d\n", tick, udpin_buffer[0], udpin_buffer[1], udpin_buffer[2]);
        
        // end of main loop
        myled = ! myled; // toggle LED1
        wait (LOOP_INTERVAL_MILISEC MSEC);
    }
    
    sock.close();
    eth.disconnect();
    myled = 0; // turn off LED1
}
            
            
            
        
    

        

