#include "Led_Lcd.h"

#define LENGTH_SIDE_SQUARE 80

DigitalOut myled(LED1);

LedLcd::LedLcd(unsigned char ucColumnNr){    
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetFont(&Font24);
    square_x_pos = ucColumnNr * LENGTH_SIDE_SQUARE;
}

void LedLcd::On(unsigned char uLedLcdNumber){
    char cText[2] = {'0'};
    char *pText = cText;
    
    for(unsigned char ucSquareCounter = 0; ucSquareCounter <= 3; ucSquareCounter++){
        *pText += 1;
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.DrawRect(square_x_pos, ucSquareCounter * LENGTH_SIDE_SQUARE, LENGTH_SIDE_SQUARE, LENGTH_SIDE_SQUARE);
        if(ucSquareCounter == uLedLcdNumber){
            lcd.SetTextColor(LCD_COLOR_MAGENTA);
        }
        else{
            lcd.SetTextColor(LCD_COLOR_BLUE);
        }
        lcd.FillRect(square_x_pos + 1, ucSquareCounter * LENGTH_SIDE_SQUARE + 1, LENGTH_SIDE_SQUARE - 2, LENGTH_SIDE_SQUARE - 2);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(square_x_pos, ucSquareCounter * LENGTH_SIDE_SQUARE, (uint8_t *)pText, LEFT_MODE);
    }
}
