#include "Keyboard.h"

Keyboard::Keyboard(unsigned char ucIdx) {
    ucColIdx = ucIdx;
    Init(240,320);
}

enum KeyboardState Keyboard::eRead(void) {
    TS_StateTypeDef TS_State;
    GetState(&TS_State); 
    
    for(unsigned char ucButton=BUTTON_0; ucButton<=BUTTON_3; ++ucButton) {
        KeyboardState btn_idx = static_cast<KeyboardState>(ucButton);
        if ((TS_State.TouchDetected) && (TS_State.Y > 80*(btn_idx-1) ) && (TS_State.Y < btn_idx*80) && (TS_State.X > (80 * ucColIdx)) && (TS_State.X < (80 * (ucColIdx + 1)))){
            return btn_idx;
        }
    }
    return RELASED; 
}