#include "Led.h"
#include "LCD_DISCO_F429ZI.h"

extern LCD_DISCO_F429ZI Lcd;

Led::Led(unsigned char ucColIdx, unsigned char ucRowIdx) {
    ucColumn = ucColIdx;
    ucRow = ucRowIdx;
    Lcd.SetTextColor(LCD_COLOR_GREEN);
    Lcd.DrawRect(80*ucColumn, 80*ucRow, 80, 80);
}

void Led::On(void) {
    Redraw(LCD_COLOR_YELLOW);
}

void Led::Off(void) {
    Redraw(LCD_COLOR_BLUE);
}

void Led::Redraw(uint32_t Color) {
    Lcd.SetBackColor(LCD_COLOR_RED);
    Lcd.SetTextColor(Color);
    Lcd.FillRect(1+ (ucColumn * 80), (ucRow*80 + 1), 79, 79);
    Lcd.SetTextColor(LCD_COLOR_WHITE);
    unsigned char ucAscii[2] = {48 + ucRow, 0};
    Lcd.DisplayStringAt((ucColumn * 80), (ucRow * 80), (uint8_t *)ucAscii, LEFT_MODE);       
}
