#include "Led_Lcd.h"

LedLcd::LedLcd(unsigned char ucIdx) {
    ucColIdx = ucIdx;
    SetFont(&Font24);
    Clear(LCD_COLOR_BLACK);
    SetTextColor(LCD_COLOR_GREEN);
    for(unsigned char I = 0; I < 4; I++) {
        DrawRect(80*ucColIdx, 80*I, 80, 80);    
    } 
}

void LedLcd::On(unsigned char ucIdx) {
    SetBackColor(LCD_COLOR_RED);   
    for(unsigned char I = 0; I < 4; I++) {
        if(I == ucIdx) {
            SetTextColor(LCD_COLOR_GREEN);
        }
        else {
            SetTextColor(LCD_COLOR_BLUE);
        }
        FillRect(1+ (ucColIdx * 80), (I*80 + 1), 79, 79); 
        SetTextColor(LCD_COLOR_WHITE);
        unsigned char ucAscii[2] = {48 + I, 0};
        DisplayStringAt((ucColIdx * 80), (I * 80), (uint8_t *)ucAscii, LEFT_MODE);      
    } 
}