#include "Keyboard_Ts.h"

KeyboardTs::KeyboardTs(unsigned char ucIdx) {
    ucColIdx = ucIdx;
    Init(240,320);
}

enum KeyboardState KeyboardTs::eRead(void) {
    TS_StateTypeDef TS_State;
    GetState(&TS_State); 
    if ((TS_State.TouchDetected) && (TS_State.Y > 0 ) && (TS_State.Y < 80) && (TS_State.X > (80 * ucColIdx)) && (TS_State.X < (80 * (ucColIdx + 1)))) {
        return BUTTON_1;
    }
    else if ((TS_State.TouchDetected) && (TS_State.Y > 80 ) && (TS_State.Y < 160) && (TS_State.X > (80 * ucColIdx)) && (TS_State.X < (80 * (ucColIdx + 1)))) {
        return BUTTON_2;
    }
    else if ((TS_State.TouchDetected) && (TS_State.Y > 160 ) && (TS_State.Y < 240) && (TS_State.X > (80 * ucColIdx)) && (TS_State.X < (80 * (ucColIdx + 1)))) {
        return BUTTON_3;
    } 
    else if ((TS_State.TouchDetected) && (TS_State.Y > 240 ) && (TS_State.Y < 320) && (TS_State.X > (80 * ucColIdx)) && (TS_State.X < (80 * (ucColIdx + 1)))) {
        return BUTTON_4;
    } 
    else{
        return RELASED;
    }   
}