#ifndef DECODER
#define DECODER


#include "mbed.h"


#define NULL 0
#define TERMINATOR '\r'
#define DELIMITER_CHAR 0x20

#define HEX_bm 0x000F
#define MAX_TOKEN_NR 2
#define MAX_KEYWORD_STRING_LTH 6
#define MAX_KEYWORD_NR 4

typedef enum TokenType 
{KEYWORD, NUMBER, STRING} TokenType;

typedef enum KeywordCode 
{ ID, CLB, GT, ST } KeywordCode;

typedef union TokenValue
{
enum KeywordCode eKeyword;
unsigned int uiNumber;
char *pcString; 
} TokenValue;

typedef struct Token
{
enum TokenType eType; 
union TokenValue uValue; 
} Token;


typedef struct Keyword
{
enum KeywordCode eCode;
char cString[MAX_KEYWORD_STRING_LTH + 1];
} Keyword;


class Decoder {
    private:
        struct Token asToken[MAX_TOKEN_NR];
        unsigned char ucTokenCnt;
        void ReplaceCharactersInString(char pcString[],char cOldChar,char cNewChar);
        enum Result eHexStringToUInt(char pcStr[],unsigned int *puiValue);
        unsigned char ucFindTokensInString(char *pcString);
        enum Result eStringToKeyword (char pcStr[],enum KeywordCode *peKeywordCode);
        void DecodeTokens(unsigned char ucTokenCnt);
    public:
        void DecodeMsg(char *pcString);
        enum TokenType eGetTokenType(unsigned char ucIdx);
        enum KeywordCode eGetKeyword(unsigned char ucIdx);
        unsigned int uiGetNumber(unsigned char ucIdx);
        unsigned char GetTokenCnt(void);
};


#endif
