#include "mbed.h"
#include "decoder.h"
#include "uart.h"
#include "stepper.h"

int main() {
    Decoder MyDecoder;
    Uart MyUart;
    Stepper MyStepper;
    
    char cTablica[BUFFER_SIZE];
    char cCorrectResponse[] = "ok\n";
    char cUnknownKeyword[] = "unknowncommand\n";
    char cIdentifier[] = "id anyidentyfier\n";
   
    while(1){
        if(!MyUart.gets(cTablica, BUFFER_SIZE)){        
            MyDecoder.DecodeMsg(cTablica);
            if ((MyDecoder.eGetTokenType(0) == KEYWORD) & (MyDecoder.GetTokenCnt() != 0)){
                switch (MyDecoder.eGetKeyword(0)){
                    case (ID):
                        MyUart.puts(cIdentifier, BUFFER_SIZE);
                        break;
                    case (CLB):
                        MyStepper.Callib();
                        MyUart.puts(cCorrectResponse, BUFFER_SIZE);
                        break;
                    case (GT):
                        MyStepper.Goto(MyDecoder.uiGetNumber(1));
                        MyUart.puts(cCorrectResponse, BUFFER_SIZE);
                        break;
                    case (ST):
                        MyStepper.Step(MyDecoder.uiGetNumber(1));
                        MyUart.puts(cCorrectResponse, BUFFER_SIZE);
                        break;
                    default:
                        break;
                }
            }
            else {
                MyUart.puts(cUnknownKeyword, BUFFER_SIZE);
            }
        }
    }
}
