#include "stepper.h"

#define TDELAY 0.2

enum Step{LEFT,RIGHT};

Stepper::Stepper(void) : Button(USER_BUTTON){
}

void Stepper::Step(enum Step eStep){
    if(eStep == LEFT){
        ucLedIdx --;
    }
    else if(eStep == RIGHT){
        ucLedIdx ++;
    }
    else{}
    ucLedIdx = ucLedIdx % 4;
    MyLed.On(ucLedIdx);
    MyGui.RefreshLeds(ucLedIdx);
    MyGui.RefreshTop(ucCurrentPos);
}

void Stepper::StepLeft(void){
    ucCurrentPos --;
    Step(LEFT);
}

void Stepper::StepRight(void){
    ucCurrentPos ++;
    Step(RIGHT);
}

void Stepper::Callib(void) {
    while(!Button) {
        StepRight();
        wait(TDELAY);
    }
    MyGui.SetRelAngle(ucCurrentPos);
    ucCurrentPos = 0;
}

void Stepper::Goto(unsigned char ucDestination) {
    ucDesiredPos = ucDestination;
    while (ucCurrentPos > ucDesiredPos) {
        StepLeft();
        wait(TDELAY);
    }
    while (ucCurrentPos < ucDesiredPos) {
        StepRight();
        wait(TDELAY);
    } 
}

void Stepper::Step(unsigned char ucSteps) {
    ucDesiredPos = ucCurrentPos + ucSteps;
    while (ucCurrentPos < ucDesiredPos) {
        StepRight();
        wait(TDELAY);
    } 
}
