#include "gui.h"

#define pi 3.14159265359

Gui::Gui() {
    Clear(LCD_COLOR_WHITE);
    SetTextColor(LCD_COLOR_BLACK);
    for(unsigned char i=0; i<4; i++) {
        DrawCircle((32 + i*58), 284, 25);
    }   
    DrawTop();
    DrawLine(120, 130, 120, 25);
    ucInitialPos = 0;
}

void Gui::DrawTop(void) {
    SetTextColor(LCD_COLOR_BLACK);
    DrawCircle(120, 130, 105);
    FillCircle(120, 130, 105);
    SetTextColor(LCD_COLOR_WHITE);
    FillCircle(120, 130, 25);
}

void Gui::RefreshLeds(unsigned char ucIdx) {
    SetTextColor(LCD_COLOR_WHITE);
    for(unsigned char i=0; i<4; i++) {
        FillCircle((32 + i*58), 284, 24);
    }
    SetTextColor(LCD_COLOR_CYAN);
    switch(ucIdx){
        case 0:
            FillCircle(32, 284, 24);
            break;
        case 1:
            FillCircle(90, 284, 24);
            break;
        case 2:
            FillCircle(148, 284, 24);
            break;
        case 3:
            FillCircle(206, 284, 24);
            break;
        default:
            break;
    }
    SetTextColor(LCD_COLOR_BLACK);
    for(unsigned char i=0; i<4; i++) {
        DrawCircle((32 + i*58), 284, 25);
    }
}

void Gui::RefreshTop(unsigned char ucPos){
    float fAngle = (((ucPos+ucInitialPos)*pi)/24);
    DrawTop();
    SetTextColor(LCD_COLOR_WHITE);
    DrawLine(120, 130, 120+105*sin(fAngle), 130-105*cos(fAngle));   
}

void Gui::SetRelAngle(unsigned char ucInitial){
    ucInitialPos = ucInitial;    
}