#include "decoder.h"


struct Keyword asKeywordList[MAX_KEYWORD_NR] = {
    {ID, "id"},
    {CLB, "callib"},
    {GT, "goto"},
    {ST, "step"},
};

enum Result { OK, NOK };


void Decoder::ReplaceCharactersInString(char pcString[],char cOldChar,char cNewChar){
  
    unsigned char ucCharCounter;
  
    for(ucCharCounter=0;pcString[ucCharCounter]!='\0';ucCharCounter++){
        if(pcString[ucCharCounter] == cOldChar) pcString[ucCharCounter] = cNewChar;
    }
}
 
unsigned char Decoder::ucFindTokensInString(char *pcString){
  
    unsigned char ucTokenPointer;
    unsigned char ucDelimiterCounter;
    char cCurrentChar;
    enum State {TOKEN, DELIMITER};
    enum State eState = DELIMITER;
    ucDelimiterCounter = 0;
    
    for(ucTokenPointer=0;;ucTokenPointer++){
        cCurrentChar = pcString[ucTokenPointer];
        switch(eState){
            case DELIMITER:
                if(cCurrentChar == '\0') 
                    return ucDelimiterCounter;
                else if(cCurrentChar == ' ') {}
                else {
                    eState = TOKEN;
                    asToken[ucDelimiterCounter].uValue.pcString = pcString+ucTokenPointer;
                    ucDelimiterCounter++;
                }
                break;
            case TOKEN:
                if(cCurrentChar == '\0') 
                    return ucDelimiterCounter;
                else if(ucDelimiterCounter == MAX_TOKEN_NR) 
                    return ucDelimiterCounter;
                else if(cCurrentChar != ' ') {}
                else 
                    eState = DELIMITER;
                break;
        }
    }
}

enum Result Decoder::eStringToKeyword (char pcStr[],enum KeywordCode *peKeywordCode){
  
    unsigned char ucTokenCounter;
  
    for(ucTokenCounter=0;ucTokenCounter<MAX_KEYWORD_NR;ucTokenCounter++){
        if (!strcmp(pcStr, asKeywordList[ucTokenCounter].cString)) {
            *peKeywordCode = asKeywordList[ucTokenCounter].eCode;
            return OK;
        }
    }
    return NOK;
}

void Decoder::DecodeTokens(unsigned char ucTokenCnt){
  
    unsigned char ucTokenCounter;
    Token* tValue;
  
    for(ucTokenCounter=0;ucTokenCounter<ucTokenCnt;ucTokenCounter++){
        tValue = &asToken[ucTokenCounter];
        if (eStringToKeyword(tValue->uValue.pcString,&tValue->uValue.eKeyword) == OK) tValue->eType = KEYWORD;
        else if ((int)strtol(tValue->uValue.pcString, NULL, 0)) {
            tValue->uValue.uiNumber = (int)strtol(tValue->uValue.pcString, NULL, 0);
            tValue->eType = NUMBER;
        }
        else tValue->eType = STRING;
    }
}

void Decoder::DecodeMsg(char *pcString){
  
    ucTokenCnt = ucFindTokensInString(pcString);
    ReplaceCharactersInString(pcString,' ','\0');
    DecodeTokens(ucTokenCnt);
}

enum TokenType Decoder::eGetTokenType(unsigned char ucIdx) {
    return asToken[ucIdx].eType;    
}

unsigned char Decoder::GetTokenCnt(void) {
    return ucTokenCnt;
}

enum KeywordCode Decoder::eGetKeyword(unsigned char ucIdx) {
    return asToken[ucIdx].uValue.eKeyword;    
}

unsigned int Decoder::uiGetNumber(unsigned char ucIdx) {
    return asToken[ucIdx].uValue.uiNumber;    
}
