#include "mbed.h"
#include "MMA8451Q.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define HABILITADO 1
#define DESHABILITADO 2
#define NADA 0
#define PASOS_MINIMOS 16
#define APP 5
#define CONTROL 6
#define LOOP 7
#define DERECHA 0
#define IZQUIERDA 1
#define MOVIENDO 1
#define QUIETO 0
#define VALORES_MOTOR 1
#define VELOCIDAD_MOTOR 2
#define MODO_DE_CONTROL 3
#define CONF_LOOP 4
#define MAX_SLIDE 62755
#define MAX_TILT 3150
#define MAX_PAN 3200
#define PUNTO_E 5
#define TIME_LAPSE 8

/*
    Loop

*/

enum {START,
      SLIDE,
      S1,
      S2,
      S3,
      TILT,
      T1,
      T2,
      T3,
      PAN,
      P1,
      P2,
      P3,
      BOTONES,
      B1,
      B2,
      CRC,
      FIN,
      V1,
      INICIO,
      V2,
      HAB_JOYSTICK,
      LOOP_HAB,
      L_DELAY1,
      L_DELAY2,
      LD_UNIDAD,
      L_TIMEOUT1,
      L_TIMEOUT2,
      LT_UNIDAD,
      PUNTOE,
      PRECISION,
      TIMELAPSE,
      T_LADO,
      T_DURACION,
      T_DURACION2,
      T_UNIDAD,
      T_MODO
     };

enum {
    ESPERO, PASO, DELAY, RIGHT, LEFT, HOLD
};


AnalogIn ana(PTB0);

// -------------- Manejo Slide

DigitalOut Slide_dir(PTC7);
DigitalOut Slide_step(PTC0);

DigitalIn fc1(PTC13);
DigitalIn fc2(PTC12);

void MAQ_VSlide(int velocidad_deseada, int direccion);    //Maquina de estados que controlará el motor de slide por Velocidad ( usada por los joysticks )
void timeoutVSlide();    // Funcion que será llamada por el Timeout que use para realizar los pasos del motor de slide
void paso_VSlide();     // Funcion que será llamada por un ticker para que todos los pasos se realicen cada el mismo tiempo, y no dependiendo de la velocidad

Ticker ticker_VSlide;   // Ticker que llamará la funcion paso_VSlide() cada 10ms
Timeout VSlide;     // Timeout que usaré para cambiar de estado en la maquina de control por velocidad

int estado_VSlide = ESPERO; // Variable que indica el estado en el que se encuentra la maquina de estados
int hab_maq_VSlide = DESHABILITADO;  // Habilitacion de dicha maquina de estados
int timeout_VSlide = DESHABILITADO;  // Variable que que se habilitará cuando el tiempo establecido en el Timeout se cumpla ( usada para cambiar de estado)
int direccion_VSlide = DERECHA; // Variable que voy a usar para indicar la direccion que tendrá el giro del motor
int velocidad_VSlide = 1;   // Variable que voy a usar para indicar la velocidad a la que quiero que se mueva el motor
volatile int incremento_VSlide = DESHABILITADO;// Variable que voy a usar para realizar los pasos siempre cada el mismo tiempo, y no  cada vez mas rapido.
int stop_VSlide = MOVIENDO;   // Variable que me indicará si el motor se esta moviendo o esta quieto, para poder cambiar de modo SOLO cuando se encuente quieto
int intensidad_VSlide = 10; // Variable que indica el que tan rapido es el multiplicador de la velocidad del joystick ( Varia de 1 (lento) a 10 (rapido))

// -------------- Manejo Tilt

DigitalOut Tilt_dir(PTC4);
DigitalOut Tilt_step(PTC3);

DigitalIn opto_tilt(PTC2);

void MAQ_VTilt(int velocidad_deseada, int direccion);    //Maquina de estados que controlará el motor de slide por Velocidad ( usada por los joysticks )
void timeoutVTilt();    // Funcion que será llamada por el Timeout que use para realizar los pasos del motor de slide
void paso_VTilt();     // Funcion que será llamada por un ticker para que todos los pasos se realicen cada el mismo tiempo, y no dependiendo de la velocidad

Ticker ticker_VTilt;   // Ticker que llamará la funcion paso_VSlide() cada 10ms
Timeout VTilt;     // Timeout que usaré para cambiar de estado en la maquina de control por velocidad

int estado_VTilt = ESPERO; // Variable que indica el estado en el que se encuentra la maquina de estados
int hab_maq_VTilt = DESHABILITADO;  // Habilitacion de dicha maquina de estados
int timeout_VTilt = DESHABILITADO;  // Variable que que se habilitará cuando el tiempo establecido en el Timeout se cumpla ( usada para cambiar de estado)
int direccion_VTilt = DERECHA; // Variable que voy a usar para indicar la direccion que tendrá el giro del motor
int velocidad_VTilt = 1;   // Variable que voy a usar para indicar la velocidad a la que quiero que se mueva el motor
volatile int incremento_VTilt = DESHABILITADO;// Variable que voy a usar para realizar los pasos siempre cada el mismo tiempo, y no  cada vez mas rapido.
int stop_VTilt = MOVIENDO;   // Variable que me indicará si el motor se esta moviendo o esta quieto, para poder cambiar de modo SOLO cuando se encuente quieto
int intensidad_VTilt = 10; // Variable que indica el que tan rapido es el multiplicador de la velocidad del joystick ( Varia de 1 (lento) a 10 (rapido))

// -------------- Manejo Pan

DigitalOut Pan_dir(PTC6);
DigitalOut Pan_step(PTC5);

DigitalIn opto_pan(PTC1);

void MAQ_VPan(int velocidad_deseada, int direccion);    //Maquina de estados que controlará el motor de slide por Velocidad ( usada por los joysticks )
void timeoutVPan();    // Funcion que será llamada por el Timeout que use para realizar los pasos del motor de slide
void paso_VPan();     // Funcion que será llamada por un ticker para que todos los pasos se realicen cada el mismo tiempo, y no dependiendo de la velocidad

Ticker ticker_VPan;   // Ticker que llamará la funcion paso_VSlide() cada 10ms
Timeout VPan;     // Timeout que usaré para cambiar de estado en la maquina de control por velocidad

int estado_VPan = ESPERO; // Variable que indica el estado en el que se encuentra la maquina de estados
int hab_maq_VPan = DESHABILITADO;  // Habilitacion de dicha maquina de estados
int timeout_VPan = DESHABILITADO;  // Variable que que se habilitará cuando el tiempo establecido en el Timeout se cumpla ( usada para cambiar de estado)
int direccion_VPan = DERECHA; // Variable que voy a usar para indicar la direccion que tendrá el giro del motor
int velocidad_VPan = 1;   // Variable que voy a usar para indicar la velocidad a la que quiero que se mueva el motor
volatile int incremento_VPan = DESHABILITADO;// Variable que voy a usar para realizar los pasos siempre cada el mismo tiempo, y no  cada vez mas rapido.
int stop_VPan = MOVIENDO;   // Variable que me indicará si el motor se esta moviendo o esta quieto, para poder cambiar de modo SOLO cuando se encuente quieto
int intensidad_VPan = 10; // Variable que indica el que tan rapido es el multiplicador de la velocidad del joystick ( Varia de 1 (lento) a 10 (rapido))

// -------------- Modo joystick

RawSerial control(PTA2, PTA1);  // Puerto serie para recibir datos del control, no se utiliza el Tx
RawSerial app(PTE0, PTE1);    // Puerto serie para recibir Y enviar datos a la aplicacion via bluetooth

int joystick_VSlide = 120;  // Variable que guarda el valor del joystick recibido por el HC-11
int app_VSlide = 120;       // Variable que guarda el valor del joystick recibido por la aplicacion via bluetooth

int joystick_VTilt = 120;  // Variable que guarda el valor del joystick recibido por el HC-11
int app_VTilt = 120;       // Variable que guarda el valor del joystick recibido por la aplicacion via bluetooth

int joystick_VPan = 120;  // Variable que guarda el valor del joystick recibido por el HC-11
int app_VPan = 120;       // Variable que guarda el valor del joystick recibido por la aplicacion via bluetooth

int pasos_slide = 0;
int pasos_tilt = 0;
int pasos_pan = 0;

void control_joystick();
void control_app();

void MAQ_recepcion_control();
void MAQ_recepcion_app();

void interrupcion_control();
void interrupcion_app();

volatile char ingreso_control; // En la variable 'ingreso_control' e 'ingreso_app' el valor 0 representa que no se ingresó nada
volatile char ingreso_app;  // En la variable 'ingreso_control' e 'ingreso_app' el valor 0 representa que no se ingresó nada

int estado_recepcion_app = START;
int estado_recepcion_control = START;

int modo_de_funcionamiento = APP;
int modo_de_funcionamiento_actual = APP;

PinName const SDA = PTE25;
PinName const SCL = PTE24;

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
void acelerometro();
Ticker giroscopo;


enum {NUNCA, SEGUNDOS, MINUTOS, HORAS};
int loop = DESHABILITADO;
int loopRetraso = 0;
int loopRetrasoUnidadDeTiempo = SEGUNDOS;
int loopDetenerseUnidadDeTiempo = SEGUNDOS;
int loopDetenerse = NUNCA;
void control_loop();
Timeout desactivar_loop;
Timeout retraso_loop;

void off_loop();
void MAQ_loop();
int estado_maq_loop = ESPERO;
int flag_delay_loop = DESHABILITADO;
void delay_loop()
{
    flag_delay_loop = HABILITADO;
}
void secuencia_inicio();

int punto_especifico = DESHABILITADO;
int posicion_slide = 0;
int posicion_pan = 0;
void control_pe();

int tiempoTimelapse = 0;
int unidadtiempoTimelapse = 0;
int lado_Timelapse = 0;
int modo_Timelapse = 0;
int stateTimelapse = DESHABILITADO;
int flag_timelapse = 0;
void inicio_timelapse();

int main()
{

    control.baud(115200);
    control.attach(&interrupcion_control, Serial::RxIrq);
    app.baud(115200);
    app.attach(&interrupcion_app, Serial::RxIrq);

    ticker_VSlide.attach_us(&paso_VSlide,10000);
    ticker_VTilt.attach_us(&paso_VTilt,1000);
    ticker_VPan.attach_us(&paso_VPan,1000);
    giroscopo.attach(&acelerometro,0.65);
    fc1.mode(PullUp);
    fc2.mode(PullUp);

    secuencia_inicio();


    while(1) {
        // SIEMPRE leo los datos que me llegan de la APP
        if(ingreso_control != NADA) { // Cuando recibo algo en el puerto serie, lo leo.
            MAQ_recepcion_control();
            ingreso_control = NADA;
        }
        // SIEMPRE leo los datos que me llegan del control remoto, siempre y cuando esté prendido
        if(ingreso_app != NADA) { // Cuando recibo algo en el puerto serie, lo leo.
            MAQ_recepcion_app();
            ingreso_app = NADA;
        }
        if(modo_de_funcionamiento_actual != modo_de_funcionamiento) { // Si recibo orden para cambiar de modo, llevo el slide a un "modo seguro" de stop
            hab_maq_VSlide = DESHABILITADO;     // Deshabilito la maquina
            velocidad_VSlide = 0; // Seteo la velocidad en 0
            hab_maq_VTilt = DESHABILITADO;     // Deshabilito la maquina
            velocidad_VTilt = 0; // Seteo la velocidad en 0
            hab_maq_VPan = DESHABILITADO;     // Deshabilito la maquina
            velocidad_VPan = 0; // Seteo la velocidad en 0
            MAQ_VSlide(velocidad_VSlide,direccion_VSlide);
            MAQ_VTilt(velocidad_VTilt*0.1,direccion_VTilt);
            MAQ_VPan(velocidad_VPan*0.1,direccion_VPan);
            if((stop_VSlide == QUIETO)&&(stop_VTilt == QUIETO)&&(stop_VPan == QUIETO)) {
                // Reseteo la variable que indica el modo a un estado false.
                // Cambio la variable del switch de modo
                modo_de_funcionamiento_actual = modo_de_funcionamiento;
            }
        } else if(modo_de_funcionamiento_actual == modo_de_funcionamiento) { // Si no se tiene que cambiar de modo, sigo interpretando los datos recibidos
            switch(modo_de_funcionamiento) { // Vario la interpretacion de datos dependiendo lo que se elija en la app
                // Le envio a la app que modo hay actualmente
                case APP: // Caso: Controlado por APP
                    if(loop == HABILITADO) {
                        switch(punto_especifico) {
                            case HABILITADO:
                                control_pe();
                                break;
                            case DESHABILITADO:
                                control_loop();
                                break;
                        }

                        MAQ_loop();
                        MAQ_VTilt(velocidad_VTilt*0.1,direccion_VTilt);
                        MAQ_VPan(velocidad_VPan*0.1,direccion_VPan);
                        MAQ_VSlide(velocidad_VSlide,direccion_VSlide);
                    } else {
                        if(stateTimelapse == DESHABILITADO) {
                            flag_timelapse = 0;
                            control_app();
                            MAQ_VSlide(velocidad_VSlide,direccion_VSlide);
                            MAQ_VTilt(velocidad_VTilt*0.1,direccion_VTilt);
                            MAQ_VPan(velocidad_VPan*0.1,direccion_VPan);
                        } else {
                            if(flag_timelapse == 0){
                                flag_timelapse = 1;
                                inicio_timelapse();
                                
                            }
                            
                            
                        }
                    }

                    break;
                case CONTROL: // Caso: Controlado por Control remoto
                    control_joystick();
                    MAQ_VSlide(velocidad_VSlide,direccion_VSlide);
                    MAQ_VTilt(velocidad_VTilt*0.1,direccion_VTilt);
                    MAQ_VPan(velocidad_VPan*0.1,direccion_VPan);
                    break;
            }
        }
    }
}
void inicio_timelapse()
{
    switch(lado_Timelapse) {
        case IZQUIERDA:
            for(; (pasos_slide > ((MAX_SLIDE * 1)/40));) {
                MAQ_VSlide(1000,DERECHA);
            }
            break;
        case DERECHA:
            for(; (pasos_slide < ((MAX_SLIDE * 39)/40));) {
                MAQ_VSlide(1000,IZQUIERDA);
            }
            break;
    }
}
void control_pe()
{
    hab_maq_VPan = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
    if(pasos_slide > posicion_slide) {
        if((direccion_VPan == IZQUIERDA)&&(pasos_tilt < ((MAX_TILT * 39)/40))) {
            direccion_VPan = IZQUIERDA; // Establezco la direccion correspondiente del giro del motor
            velocidad_VPan = 500 * (pasos_pan * 100)/(MAX_PAN / 2) * (pasos_slide * 100)/(MAX_SLIDE / 2);   // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
        } else {
            direccion_VPan = DERECHA;
        }
    } else {
        if((direccion_VPan == DERECHA)&&(pasos_tilt > ((MAX_TILT * 1)/ 40))) {
            direccion_VPan = DERECHA; // Establezco la direccion correspondiente del giro del motor
            velocidad_VPan = 500 * (pasos_pan * 100)/(MAX_PAN / 2) * (pasos_slide * 100)/(MAX_SLIDE / 2);   // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
        } else {
            direccion_VPan = IZQUIERDA;
        }
    }
}

void off_loop()
{
    loop = DESHABILITADO;
    app.putc('$');
    app.putc('L');
    app.putc('0');
    app.putc('e');
    app.putc('!');
}
void MAQ_loop()
{
    static int prox_dir = DERECHA;
    switch(estado_maq_loop) {
        case ESPERO:

            estado_maq_loop = RIGHT;

            break;
        case RIGHT:

            if(pasos_slide < ((MAX_SLIDE * 39)/40)) {
                hab_maq_VSlide = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
                direccion_VSlide = DERECHA; // Establezco la direccion correspondiente del giro del motor
                velocidad_VSlide = intensidad_VSlide * 100;   // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
            } else {
                velocidad_VSlide = 0;
                direccion_VSlide = DERECHA;
                hab_maq_VTilt = DESHABILITADO;     // Deshabilito la maquina
                if(stop_VSlide == QUIETO) {
                    estado_maq_loop = HOLD;
                    switch(loopRetrasoUnidadDeTiempo) {
                        case SEGUNDOS:
                            retraso_loop.attach(&delay_loop,loopRetraso);
                            break;
                        case MINUTOS:
                            retraso_loop.attach(&delay_loop,loopRetraso*60);
                            break;
                        case HORAS:
                            retraso_loop.attach(&delay_loop,loopRetraso * 60); // Falta multiplicar por 60 mas
                            break;

                    }
                    prox_dir = IZQUIERDA;
                }
            }
            break;
        case HOLD:
            if(flag_delay_loop == HABILITADO) {
                flag_delay_loop = DESHABILITADO;
                switch(prox_dir) {
                    case DERECHA:
                        estado_maq_loop = RIGHT;
                        break;
                    case IZQUIERDA:
                        estado_maq_loop = LEFT;
                        break;
                }
            }
            break;
        case LEFT:
            if(pasos_slide > ((MAX_SLIDE * 1)/ 40)) {
                hab_maq_VSlide = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
                direccion_VSlide = IZQUIERDA; // Establezco la direccion correspondiente del giro del motor
                velocidad_VSlide = intensidad_VSlide * 100;   // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
            } else {
                velocidad_VSlide = 0;
                direccion_VSlide = IZQUIERDA;
                hab_maq_VTilt = DESHABILITADO;     // habilito la maquina
                if(stop_VSlide == QUIETO) {
                    estado_maq_loop = HOLD;
                    switch(loopRetrasoUnidadDeTiempo) {
                        case SEGUNDOS:
                            retraso_loop.attach(&delay_loop,loopRetraso);
                            break;
                        case MINUTOS:
                            retraso_loop.attach(&delay_loop,loopRetraso*60);
                            break;
                        case HORAS:
                            retraso_loop.attach(&delay_loop,loopRetraso * 60); // Falta multiplicar por 60 mas
                            break;
                    }
                    prox_dir = DERECHA;
                }
            }
            break;

    }

}
void secuencia_inicio()
{
    int hab_slide = 1;
    int hab_pan = 1;
    int hab_tilt = 1;
    hab_maq_VSlide = 1;
    hab_maq_VTilt = 1;
    hab_maq_VPan = 1;
    while(1) {

        if((fc1 == 0)||(fc2 == 0)) {
            hab_slide = 0;
        } else {
            if(hab_slide == 1) {
                MAQ_VSlide(1000,1);
            }
        }
        if(opto_tilt != 1) {
            if(hab_tilt == 1) {
                MAQ_VTilt(100,1);
            }
        } else {
            hab_tilt = 0;
        }
        if(opto_pan != 1) {
            if(hab_pan == 1) {
                MAQ_VPan(100,1);
            }
        } else {
            hab_pan = 0;
        }
        if((hab_slide == 0)&&(hab_tilt == 0)&&(hab_pan == 0)) {
            break;
        }
    }
    estado_VSlide = ESPERO; // Vuelvo al estado de reset
    estado_VTilt = ESPERO; // Vuelvo al estado de reset
    estado_VPan = ESPERO; // Vuelvo al estado de reset

    hab_slide = 1;
    hab_tilt = 1;
    hab_pan = 1;

    pasos_slide = 0;
    pasos_tilt = 0;
    pasos_pan = 0;

    while(1) {
        if(pasos_slide < (MAX_SLIDE / 2)) {
            MAQ_VSlide(1000,0);
        } else {
            hab_slide = 0;
        }
        if(pasos_tilt < (MAX_TILT / 2)) {
            MAQ_VTilt(100,0);
        } else {
            hab_tilt = 0;
        }
        if(pasos_pan < (MAX_PAN / 2)) {
            MAQ_VPan(100,0);
        } else {
            hab_pan = 0;
        }
        if((hab_slide == 0)&&(hab_tilt == 0)&&(hab_pan == 0)) {
            break;
        }

    }
    app.putc('a');

}
void interrupcion_control()
{
    ingreso_control = control.getc();
}
void interrupcion_app()
{
    ingreso_app = app.getc();
}
void acelerometro()
{
    float x, grados;
    int d,u;
    x = abs(acc.getAccX());
    grados = x * 90;
    app.putc('$');
    app.putc('I');
    app.putc('S');
    d = grados / 10;
    u = grados - d * 10;
    app.putc(0 + 0x30);
    app.putc(d + 0x30);
    app.putc(u + 0x30);
    app.putc('e');
    app.putc('!');

}
void control_joystick()
{
    if((joystick_VSlide >= 0)&&(joystick_VSlide <= 112)) {    // Rango del joystick que se mueve hacia una direccion

        hab_maq_VSlide = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
        direccion_VSlide = DERECHA; // Establezco la direccion correspondiente del giro del motor
        velocidad_VSlide = intensidad_VSlide * (109 - joystick_VSlide);   // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
    }
    if((joystick_VSlide >= 115)&&(joystick_VSlide <= 140)) {  // Rango del joystick donde se encuentra estable el motor
        hab_maq_VSlide = DESHABILITADO;     // Deshabilito la maquina
        velocidad_VSlide = 0; // Seteo la velocidad en 0
    }
    if((joystick_VSlide >= 145)&&(joystick_VSlide <= 255)) {  // Rango del joystick que se mueve hacia la otra direccion
        hab_maq_VSlide = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
        direccion_VSlide = IZQUIERDA;   // Establezco la direccion correspondiente del giro del motor
        velocidad_VSlide = intensidad_VSlide * (joystick_VSlide - 149);    // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
    }
    if((joystick_VTilt >= 0)&&(joystick_VTilt <= 112)) {    // Rango del joystick que se mueve hacia una direccion

        hab_maq_VTilt = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
        direccion_VTilt = DERECHA; // Establezco la direccion correspondiente del giro del motor
        velocidad_VTilt = intensidad_VTilt * (109 - joystick_VTilt);   // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
    }
    if((joystick_VTilt >= 115)&&(joystick_VTilt <= 140)) {  // Rango del joystick donde se encuentra estable el motor
        hab_maq_VTilt = DESHABILITADO;     // Deshabilito la maquina
        velocidad_VTilt = 0; // Seteo la velocidad en 0
    }
    if((joystick_VTilt >= 145)&&(joystick_VTilt <= 255)) {  // Rango del joystick que se mueve hacia la otra direccion
        hab_maq_VTilt = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
        direccion_VTilt = IZQUIERDA;   // Establezco la direccion correspondiente del giro del motor
        velocidad_VTilt = intensidad_VTilt * (joystick_VTilt - 149);    // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
    }
    if((joystick_VPan >= 0)&&(joystick_VPan <= 112)) {    // Rango del joystick que se mueve hacia una direccion

        hab_maq_VPan = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
        direccion_VPan = DERECHA; // Establezco la direccion correspondiente del giro del motor
        velocidad_VPan = intensidad_VPan * (109 - joystick_VPan);   // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
    }
    if((joystick_VPan >= 115)&&(joystick_VPan <= 140)) {  // Rango del joystick donde se encuentra estable el motor
        hab_maq_VPan = DESHABILITADO;     // Deshabilito la maquina
        velocidad_VPan = 0; // Seteo la velocidad en 0
    }
    if((joystick_VPan >= 145)&&(joystick_VPan <= 255)) {  // Rango del joystick que se mueve hacia la otra direccion
        hab_maq_VPan = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
        direccion_VPan = IZQUIERDA;   // Establezco la direccion correspondiente del giro del motor
        velocidad_VPan = intensidad_VPan * (joystick_VPan - 149);    // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
    }

}
void control_loop()
{
    if((app_VTilt >= 0)&&(app_VTilt <= 112)) {    // Rango del joystick que se mueve hacia una direccion
        if(pasos_tilt < ((MAX_TILT * 39)/40)) {
            hab_maq_VTilt = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
            direccion_VTilt = DERECHA; // Establezco la direccion correspondiente del giro del motor
            velocidad_VTilt = intensidad_VTilt * (109 - app_VTilt);   // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
        } else {
            hab_maq_VTilt = DESHABILITADO;     // Deshabilito la maquina
            velocidad_VTilt = 0; // Seteo la velocidad en 0
        }
    }
    if((app_VTilt >= 115)&&(app_VTilt <= 140)) {  // Rango del joystick donde se encuentra estable el motor
        hab_maq_VTilt = DESHABILITADO;     // Deshabilito la maquina
        velocidad_VTilt = 0; // Seteo la velocidad en 0
    }
    if((app_VTilt >= 145)&&(app_VTilt <= 255)) {  // Rango del joystick que se mueve hacia la otra direccion
        if(pasos_tilt > ((MAX_TILT * 1)/ 40)) {
            hab_maq_VTilt = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
            direccion_VTilt = IZQUIERDA;   // Establezco la direccion correspondiente del giro del motor
            velocidad_VTilt = intensidad_VTilt * (app_VTilt - 149);    // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
        } else {
            hab_maq_VTilt = DESHABILITADO;     // Deshabilito la maquina
            velocidad_VTilt = 0; // Seteo la velocidad en 0
        }
    }
    //--
    if((app_VPan >= 0)&&(app_VPan <= 112)) {    // Rango del joystick que se mueve hacia una direccion
        if(pasos_pan < ((MAX_PAN * 39)/40)) {
            hab_maq_VPan = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
            direccion_VPan = DERECHA; // Establezco la direccion correspondiente del giro del motor
            velocidad_VPan = intensidad_VPan * (109 - app_VPan);   // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
        } else {
            hab_maq_VPan = DESHABILITADO;     // Deshabilito la maquina
            velocidad_VPan = 0; // Seteo la velocidad en 0
        }
    }
    if((app_VPan >= 115)&&(app_VPan <= 140)) {  // Rango del joystick donde se encuentra estable el motor
        hab_maq_VPan = DESHABILITADO;     // Deshabilito la maquina
        velocidad_VPan = 0; // Seteo la velocidad en 0
    }
    if((app_VPan >= 145)&&(app_VPan <= 255)) {  // Rango del joystick que se mueve hacia la otra direccion
        if(pasos_pan > ((MAX_PAN * 1)/ 40)) {
            hab_maq_VPan = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
            direccion_VPan = IZQUIERDA;   // Establezco la direccion correspondiente del giro del motor
            velocidad_VPan = intensidad_VPan * (app_VPan - 149);    // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
        } else {
            hab_maq_VPan = DESHABILITADO;     // Deshabilito la maquina
            velocidad_VPan = 0; // Seteo la velocidad en 0
        }
    }
}
void control_app()
{
    if((app_VSlide >= 0)&&(app_VSlide <= 112)) {    // Rango del joystick que se mueve hacia una direccion
        if(pasos_slide < ((MAX_SLIDE * 39)/40)) {
            hab_maq_VSlide = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
            direccion_VSlide = DERECHA; // Establezco la direccion correspondiente del giro del motor
            velocidad_VSlide = intensidad_VSlide * (109 - app_VSlide);   // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
        } else {
            hab_maq_VSlide = DESHABILITADO;     // Deshabilito la maquina
            velocidad_VSlide = 0; // Seteo la velocidad en 0
        }
    }
    if((app_VSlide >= 115)&&(app_VSlide <= 140)) {  // Rango del joystick donde se encuentra estable el motor
        hab_maq_VSlide = DESHABILITADO;     // Deshabilito la maquina
        velocidad_VSlide = 0; // Seteo la velocidad en 0
    }
    if((app_VSlide >= 145)&&(app_VSlide <= 255)) {  // Rango del joystick que se mueve hacia la otra direccion
        if(pasos_slide > ((MAX_SLIDE * 1)/ 40)) {
            hab_maq_VSlide = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
            direccion_VSlide = IZQUIERDA;   // Establezco la direccion correspondiente del giro del motor
            velocidad_VSlide = intensidad_VSlide * (app_VSlide - 149);    // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
        } else {
            hab_maq_VSlide = DESHABILITADO;     // Deshabilito la maquina
            velocidad_VSlide = 0; // Seteo la velocidad en 0
        }
    }
    //--
    if((app_VTilt >= 0)&&(app_VTilt <= 112)) {    // Rango del joystick que se mueve hacia una direccion
        if(pasos_tilt < ((MAX_TILT * 39)/40)) {
            hab_maq_VTilt = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
            direccion_VTilt = DERECHA; // Establezco la direccion correspondiente del giro del motor
            velocidad_VTilt = intensidad_VTilt * (109 - app_VTilt);   // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
        } else {
            hab_maq_VTilt = DESHABILITADO;     // Deshabilito la maquina
            velocidad_VTilt = 0; // Seteo la velocidad en 0
        }
    }
    if((app_VTilt >= 115)&&(app_VTilt <= 140)) {  // Rango del joystick donde se encuentra estable el motor
        hab_maq_VTilt = DESHABILITADO;     // Deshabilito la maquina
        velocidad_VTilt = 0; // Seteo la velocidad en 0
    }
    if((app_VTilt >= 145)&&(app_VTilt <= 255)) {  // Rango del joystick que se mueve hacia la otra direccion
        if(pasos_tilt > ((MAX_TILT * 1)/ 40)) {
            hab_maq_VTilt = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
            direccion_VTilt = IZQUIERDA;   // Establezco la direccion correspondiente del giro del motor
            velocidad_VTilt = intensidad_VTilt * (app_VTilt - 149);    // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
        } else {
            hab_maq_VTilt = DESHABILITADO;     // Deshabilito la maquina
            velocidad_VTilt = 0; // Seteo la velocidad en 0
        }
    }
    //--
    if((app_VPan >= 0)&&(app_VPan <= 112)) {    // Rango del joystick que se mueve hacia una direccion
        if(pasos_pan < ((MAX_PAN * 39)/40)) {
            hab_maq_VPan = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
            direccion_VPan = DERECHA; // Establezco la direccion correspondiente del giro del motor
            velocidad_VPan = intensidad_VPan * (109 - app_VPan);   // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
        } else {
            hab_maq_VPan = DESHABILITADO;     // Deshabilito la maquina
            velocidad_VPan = 0; // Seteo la velocidad en 0
        }
    }
    if((app_VPan >= 115)&&(app_VPan <= 140)) {  // Rango del joystick donde se encuentra estable el motor
        hab_maq_VPan = DESHABILITADO;     // Deshabilito la maquina
        velocidad_VPan = 0; // Seteo la velocidad en 0
    }
    if((app_VPan >= 145)&&(app_VPan <= 255)) {  // Rango del joystick que se mueve hacia la otra direccion
        if(pasos_pan > ((MAX_PAN * 1)/ 15)) {
            hab_maq_VPan = HABILITADO;    // Habilito la maquina de estados de manejo por velocidad
            direccion_VPan = IZQUIERDA;   // Establezco la direccion correspondiente del giro del motor
            velocidad_VPan = intensidad_VPan * (app_VPan - 149);    // Seteo la velocidad, dependiendo del nivel ( de 0 a 10 ) y del valor analogico del joystick
        } else {
            hab_maq_VPan = DESHABILITADO;     // Deshabilito la maquina
            velocidad_VPan = 0; // Seteo la velocidad en 0
        }
    }
}
void timeoutVSlide()
{
    timeout_VSlide = HABILITADO;    // Aviso que pasó el tiempo que se estableció
}
void paso_VSlide()
{
    incremento_VSlide = HABILITADO; // Aviso que se puede incrementar la velocidad del motor
}
void timeoutVTilt()
{
    timeout_VTilt = HABILITADO;    // Aviso que pasó el tiempo que se estableció
}
void paso_VTilt()
{
    incremento_VTilt = HABILITADO; // Aviso que se puede incrementar la velocidad del motor
}
void timeoutVPan()
{
    timeout_VPan = HABILITADO;    // Aviso que pasó el tiempo que se estableció
}
void paso_VPan()
{
    incremento_VPan = HABILITADO; // Aviso que se puede incrementar la velocidad del motor
}
void MAQ_VSlide(int velocidad_deseada, int direccion)
{
    // Para que no existan cambios bruscos de velocidad, voy a ir incrementando el valor actual de la misma hasta llegar al punto que deseo.
    // De esta forma, seteo dos variables para poder lograr ese efecto.
    // Además, yo voy a querer que el motor no se detenga de golpe, asi que aprovecho este ultimo metodo para realizar esa operacion.

    static int ticker_actual = 0;   // Variable que me indicará el valor actual de tiempo de ticker (en micro-segundos)
    static int ticker_deseado = 0;  // Variable que me indicará el valor deseado de tiempo de ticker (en micro-segundos), depèndiendo del joystick y de la pausa que se desee lograr

    switch(estado_VSlide) {

        case ESPERO:    // Caso: Espero habilitacion de la maquina.

            stop_VSlide = QUIETO;   // Indico que la maquina no se activo todavia

            if(hab_maq_VSlide == HABILITADO) {

                Slide_dir = direccion;  // Establezco la salida fisica igual a la direccion que se indicó en la función

                ticker_actual = 1999;   // Seteo la velocidad de inicio como una lo suficientemente lenta como para considerar el motor "parado"

                ticker_deseado = (1100 - velocidad_deseada);    // Seteo el tiempo del ticker deseado, dependiendo del valor de velocidad que se haya ingresado en la funcion.

                timeout_VSlide = DESHABILITADO; // Reseteo el Flag del timeout

                VSlide.attach_us(&timeoutVSlide, ticker_actual);    // Seteo el tiempo para con el que se realizarán los cambios de estado

                estado_VSlide = PASO;   // Cambio de estado

                stop_VSlide = MOVIENDO; // Indico que el motor se esta moviendo
            }
            break;

        case PASO:  // Caso: pongo la salida de step en 1

            Slide_step = 1;   // Pongo la salida de step en 1

            if(timeout_VSlide == HABILITADO) {  // Transicion a otro estado: cuando pasó el tiempo establecido en el ticker

                timeout_VSlide = DESHABILITADO; // Reseteo el Flag del timeout

                if(velocidad_deseada != 0) {    // Siempre que la velocidad sea distinta de 0, es decir, que el joystick no esté en el estado de reposo

                    ticker_deseado = (1100 - velocidad_deseada);    // Seteo el tiempo del ticker deseado, dependiendo del valor de velocidad que se haya ingresado en la funcion.

                } else {
                    ticker_deseado = 2000;  // Si se desea el motor, establezco el ticker a un tiempo que sea tan lento como para considerar el motor parado
                }

                if(Slide_dir != direccion) {  // Caso de que la direccion deseada no sea la direccion ACTUAL del motor
                    // En este caso, primero debo detener el motor para poder así comenzar otra vez con el giro

                    if(incremento_VSlide == HABILITADO) {   // Si pasó el tiempo suficiente como para poder incrementar o disminuir la velocidad:
                        incremento_VSlide = DESHABILITADO;  // Limpio el Flag
                        ticker_actual = ticker_actual + 10; // Incremento el ticker. Esto hará que cada vez el motor gire mas lento
                    }
                    if(ticker_actual >= 2000) { // Cuando considero que el motor está casi detenido:
                        Slide_dir = direccion;    // Cambio la direccion
                    }
                } else if(Slide_dir == direccion) {   // Caso de que la direccion sea la misma que la deseada:
                    // En este caso, voy a aumentar o disminuir la velocidad dependiendo de lo que se desee

                    if(ticker_actual > ticker_deseado) {    // Si el motor esta yendo mas lento que lo que yo deseo:
                        if(incremento_VSlide == HABILITADO) { // Y me encuentro habilitado para incrementar:
                            incremento_VSlide = DESHABILITADO;    // Limpio el Flag
                            ticker_actual = ticker_actual - 10; // Y aumento la velocidad
                        }
                    }
                    if(ticker_actual < ticker_deseado) {    // Si el motor esta yendo mas rapido de lo que debería:
                        if(incremento_VSlide == HABILITADO) { // Y me encuentro habilitado para incrementar:
                            incremento_VSlide = DESHABILITADO;    // Limpio el Flag
                            ticker_actual = ticker_actual + 10; // Y disminuyo la velocidad
                        }
                    }
                }
                VSlide.attach_us(&timeoutVSlide, ticker_actual);    // Seteo el tiempo para con el que se realizarán los cambios de estado
                estado_VSlide = DELAY;  // Cambio de estado
            }
            break;

        case DELAY: // Caso: pongo la salida de step en 0
            Slide_step = 0;   // Pongo la salida de step en 0

            if(timeout_VSlide == HABILITADO) {  // Transicion a otro estado: cuando pasó el tiempo establecido en el ticker
                timeout_VSlide = DESHABILITADO; // Limpio Flag

                if(ticker_actual >= 2000) { // Si la velocidad del motor es mas lenta de lo que yo considero como parado:

                    estado_VSlide = ESPERO; // Vuelvo al estado de reset
                    hab_maq_VSlide = DESHABILITADO;     // Deshabilito la maquina

                } else {    // Si el motor "sigue moviendose":
                    VSlide.attach_us(&timeoutVSlide, ticker_actual);    // Vuelvo a establecer un tiempo para cambiar de estado
                    if(Slide_dir == 1) {
                        pasos_slide--;  // Como hice un paso, lo sumo a la cuenta.
                    } else {
                        pasos_slide++;  // Como hice un paso, lo sumo a la cuenta.
                    }

                    estado_VSlide = PASO;   // Cambio de estado
                }
            }
            break;
    }
}
void MAQ_VTilt(int velocidad_deseada, int direccion)
{
    // Para que no existan cambios bruscos de velocidad, voy a ir incrementando el valor actual de la misma hasta llegar al punto que deseo.
    // De esta forma, seteo dos variables para poder lograr ese efecto.
    // Además, yo voy a querer que el motor no se detenga de golpe, asi que aprovecho este ultimo metodo para realizar esa operacion.

    static int ticker_actual = 0;   // Variable que me indicará el valor actual de tiempo de ticker (en micro-segundos)
    static int ticker_deseado = 0;  // Variable que me indicará el valor deseado de tiempo de ticker (en micro-segundos), depèndiendo del joystick y de la pausa que se desee lograr

    switch(estado_VTilt) {

        case ESPERO:    // Caso: Espero habilitacion de la maquina.

            stop_VTilt = QUIETO;   // Indico que la maquina no se activo todavia

            if(hab_maq_VTilt == HABILITADO) {

                Tilt_dir = direccion;  // Establezco la salida fisica igual a la direccion que se indicó en la función

                ticker_actual = 1999;   // Seteo la velocidad de inicio como una lo suficientemente lenta como para considerar el motor "parado"

                ticker_deseado = (1300 - velocidad_deseada);    // Seteo el tiempo del ticker deseado, dependiendo del valor de velocidad que se haya ingresado en la funcion.

                timeout_VTilt = DESHABILITADO; // Reseteo el Flag del timeout

                VTilt.attach_us(&timeoutVTilt, ticker_actual);    // Seteo el tiempo para con el que se realizarán los cambios de estado

                estado_VTilt = PASO;   // Cambio de estado

                stop_VTilt = MOVIENDO; // Indico que el motor se esta moviendo
            }
            break;

        case PASO:  // Caso: pongo la salida de step en 1

            Tilt_step = 1;   // Pongo la salida de step en 1

            if(timeout_VTilt == HABILITADO) {  // Transicion a otro estado: cuando pasó el tiempo establecido en el ticker

                timeout_VTilt = DESHABILITADO; // Reseteo el Flag del timeout

                if(velocidad_deseada != 0) {    // Siempre que la velocidad sea distinta de 0, es decir, que el joystick no esté en el estado de reposo

                    ticker_deseado = (1300 - velocidad_deseada);    // Seteo el tiempo del ticker deseado, dependiendo del valor de velocidad que se haya ingresado en la funcion.

                } else {
                    ticker_deseado = 2000;  // Si se desea el motor, establezco el ticker a un tiempo que sea tan lento como para considerar el motor parado
                }

                if(Tilt_dir != direccion) {  // Caso de que la direccion deseada no sea la direccion ACTUAL del motor
                    // En este caso, primero debo detener el motor para poder así comenzar otra vez con el giro

                    if(incremento_VTilt == HABILITADO) {   // Si pasó el tiempo suficiente como para poder incrementar o disminuir la velocidad:
                        incremento_VTilt = DESHABILITADO;  // Limpio el Flag
                        ticker_actual = ticker_actual + 10; // Incremento el ticker. Esto hará que cada vez el motor gire mas lento
                    }
                    if(ticker_actual >= 2000) { // Cuando considero que el motor está casi detenido:
                        Tilt_dir = direccion;    // Cambio la direccion
                    }
                } else if(Tilt_dir == direccion) {   // Caso de que la direccion sea la misma que la deseada:
                    // En este caso, voy a aumentar o disminuir la velocidad dependiendo de lo que se desee

                    if(ticker_actual > ticker_deseado) {    // Si el motor esta yendo mas lento que lo que yo deseo:
                        if(incremento_VTilt == HABILITADO) { // Y me encuentro habilitado para incrementar:
                            incremento_VTilt = DESHABILITADO;    // Limpio el Flag
                            ticker_actual = ticker_actual - 10; // Y aumento la velocidad
                        }
                    }
                    if(ticker_actual < ticker_deseado) {    // Si el motor esta yendo mas rapido de lo que debería:
                        if(incremento_VTilt == HABILITADO) { // Y me encuentro habilitado para incrementar:
                            incremento_VTilt = DESHABILITADO;    // Limpio el Flag
                            ticker_actual = ticker_actual + 10; // Y disminuyo la velocidad
                        }
                    }
                }
                VTilt.attach_us(&timeoutVTilt, ticker_actual);    // Seteo el tiempo para con el que se realizarán los cambios de estado
                estado_VTilt = DELAY;  // Cambio de estado
            }
            break;

        case DELAY: // Caso: pongo la salida de step en 0
            Tilt_step = 0;   // Pongo la salida de step en 0

            if(timeout_VTilt == HABILITADO) {  // Transicion a otro estado: cuando pasó el tiempo establecido en el ticker
                timeout_VTilt = DESHABILITADO; // Limpio Flag

                if(ticker_actual >= 2000) { // Si la velocidad del motor es mas lenta de lo que yo considero como parado:

                    estado_VTilt = ESPERO; // Vuelvo al estado de reset
                    hab_maq_VTilt = DESHABILITADO;     // Deshabilito la maquina

                } else {    // Si el motor "sigue moviendose":
                    VTilt.attach_us(&timeoutVTilt, ticker_actual);    // Vuelvo a establecer un tiempo para cambiar de estado
                    if(Tilt_dir == 1) {
                        pasos_tilt--;  // Como hice un paso, lo sumo a la cuenta.
                    } else {
                        pasos_tilt++;  // Como hice un paso, lo sumo a la cuenta.
                    }
                    estado_VTilt = PASO;   // Cambio de estado
                }
            }
            break;
    }
}
void MAQ_VPan(int velocidad_deseada, int direccion)
{
    // Para que no existan cambios bruscos de velocidad, voy a ir incrementando el valor actual de la misma hasta llegar al punto que deseo.
    // De esta forma, seteo dos variables para poder lograr ese efecto.
    // Además, yo voy a querer que el motor no se detenga de golpe, asi que aprovecho este ultimo metodo para realizar esa operacion.

    static int ticker_actual = 0;   // Variable que me indicará el valor actual de tiempo de ticker (en micro-segundos)
    static int ticker_deseado = 0;  // Variable que me indicará el valor deseado de tiempo de ticker (en micro-segundos), depèndiendo del joystick y de la pausa que se desee lograr

    switch(estado_VPan) {

        case ESPERO:    // Caso: Espero habilitacion de la maquina.

            stop_VPan = QUIETO;   // Indico que la maquina no se activo todavia

            if(hab_maq_VPan == HABILITADO) {

                Pan_dir = direccion;  // Establezco la salida fisica igual a la direccion que se indicó en la función

                ticker_actual = 1999;   // Seteo la velocidad de inicio como una lo suficientemente lenta como para considerar el motor "parado"

                ticker_deseado = (1300 - velocidad_deseada);    // Seteo el tiempo del ticker deseado, dependiendo del valor de velocidad que se haya ingresado en la funcion.

                timeout_VPan = DESHABILITADO; // Reseteo el Flag del timeout

                VPan.attach_us(&timeoutVPan, ticker_actual);    // Seteo el tiempo para con el que se realizarán los cambios de estado

                estado_VPan = PASO;   // Cambio de estado

                stop_VPan = MOVIENDO; // Indico que el motor se esta moviendo
            }
            break;

        case PASO:  // Caso: pongo la salida de step en 1

            Pan_step = 1;   // Pongo la salida de step en 1

            if(timeout_VPan == HABILITADO) {  // Transicion a otro estado: cuando pasó el tiempo establecido en el ticker

                timeout_VPan = DESHABILITADO; // Reseteo el Flag del timeout

                if(velocidad_deseada != 0) {    // Siempre que la velocidad sea distinta de 0, es decir, que el joystick no esté en el estado de reposo

                    ticker_deseado = (1300 - velocidad_deseada);    // Seteo el tiempo del ticker deseado, dependiendo del valor de velocidad que se haya ingresado en la funcion.

                } else {
                    ticker_deseado = 2000;  // Si se desea el motor, establezco el ticker a un tiempo que sea tan lento como para considerar el motor parado
                }

                if(Pan_dir != direccion) {  // Caso de que la direccion deseada no sea la direccion ACTUAL del motor
                    // En este caso, primero debo detener el motor para poder así comenzar otra vez con el giro

                    if(incremento_VPan == HABILITADO) {   // Si pasó el tiempo suficiente como para poder incrementar o disminuir la velocidad:
                        incremento_VPan = DESHABILITADO;  // Limpio el Flag
                        ticker_actual = ticker_actual + 10; // Incremento el ticker. Esto hará que cada vez el motor gire mas lento
                    }
                    if(ticker_actual >= 2000) { // Cuando considero que el motor está casi detenido:
                        Pan_dir = direccion;    // Cambio la direccion
                    }
                } else if(Pan_dir == direccion) {   // Caso de que la direccion sea la misma que la deseada:
                    // En este caso, voy a aumentar o disminuir la velocidad dependiendo de lo que se desee

                    if(ticker_actual > ticker_deseado) {    // Si el motor esta yendo mas lento que lo que yo deseo:
                        if(incremento_VPan == HABILITADO) { // Y me encuentro habilitado para incrementar:
                            incremento_VPan = DESHABILITADO;    // Limpio el Flag
                            ticker_actual = ticker_actual - 10; // Y aumento la velocidad
                        }
                    }
                    if(ticker_actual < ticker_deseado) {    // Si el motor esta yendo mas rapido de lo que debería:
                        if(incremento_VPan == HABILITADO) { // Y me encuentro habilitado para incrementar:
                            incremento_VPan = DESHABILITADO;    // Limpio el Flag
                            ticker_actual = ticker_actual + 10; // Y disminuyo la velocidad
                        }
                    }
                }
                VPan.attach_us(&timeoutVPan, ticker_actual);    // Seteo el tiempo para con el que se realizarán los cambios de estado
                estado_VPan = DELAY;  // Cambio de estado
            }
            break;

        case DELAY: // Caso: pongo la salida de step en 0
            Pan_step = 0;   // Pongo la salida de step en 0

            if(timeout_VPan == HABILITADO) {  // Transicion a otro estado: cuando pasó el tiempo establecido en el ticker
                timeout_VPan = DESHABILITADO; // Limpio Flag

                if(ticker_actual >= 2000) { // Si la velocidad del motor es mas lenta de lo que yo considero como parado:

                    estado_VPan = ESPERO; // Vuelvo al estado de reset
                    hab_maq_VPan = DESHABILITADO;     // Deshabilito la maquina

                } else {    // Si el motor "sigue moviendose":
                    VPan.attach_us(&timeoutVPan, ticker_actual);    // Vuelvo a establecer un tiempo para cambiar de estado
                    if(Pan_dir == 1) {
                        pasos_pan--;  // Como hice un paso, lo sumo a la cuenta.
                    } else {
                        pasos_pan++;  // Como hice un paso, lo sumo a la cuenta.
                    }
                    estado_VPan = PASO;   // Cambio de estado
                }
            }
            break;
    }
}
void MAQ_recepcion_app()
{
    static int aux_slide[3];
    static int aux_tilt[3];
    static int aux_pan[3];
    static int aux_botones[2];
    static int crc;
    static int aux_vel[2];
    static int trama_recibida = 0;
    static int aux_modo = 0;
    static int aux_loop = DESHABILITADO;
    static int t_delay[4];
    static int t_out[4];
    static int aux_pe;
    static int aux_accuracy[2];
    static int aux_timelapse;
    static int timelapse_t[4];
    static int ladoTimelapse = 0;
    static int modoTimelapse = 0;

    switch(estado_recepcion_app) {
        case START:

            // Reseteo todas las variables
            aux_slide[0] = 0;
            aux_slide[1] = 0;
            aux_slide[2] = 0;
            aux_tilt[0] = 0;
            aux_tilt[1] = 0;
            aux_tilt[2] = 0;
            aux_pan[0] = 0;
            aux_pan[1] = 0;
            aux_pan[2] = 0;
            aux_vel[0] = 0;
            aux_vel[1] = 0;
            crc = 0;
            trama_recibida = 0;
            aux_modo = 0;
            aux_loop = DESHABILITADO;
            t_delay[1]=0;
            t_delay[2]=0;
            t_delay[3]=0;
            t_out[1]=0;
            t_out[2]=0;
            t_out[3]=0;
            aux_accuracy[0] = 0;
            aux_accuracy[1] = 0;
            aux_pe = 0;
            aux_timelapse;
            timelapse_t[1]=0;
            timelapse_t[2]=0;
            timelapse_t[3]=0;
            ladoTimelapse = 0;
            modoTimelapse = 0;


            if(ingreso_app == '$') {
                estado_recepcion_app = INICIO;
            }
            break;

        case INICIO:

            // Reseteo todas las variables
            aux_slide[0] = 0;
            aux_slide[1] = 0;
            aux_slide[2] = 0;
            aux_tilt[0] = 0;
            aux_tilt[1] = 0;
            aux_tilt[2] = 0;
            aux_pan[0] = 0;
            aux_pan[1] = 0;
            aux_pan[2] = 0;
            aux_vel[0] = 0;
            aux_vel[1] = 0;
            crc = 0;
            trama_recibida = 0;
            aux_modo = 0;
            aux_loop = DESHABILITADO;
            t_delay[1]=0;
            t_delay[2]=0;
            t_delay[3]=0;
            t_out[1]=0;
            t_out[2]=0;
            t_out[3]=0;
            aux_accuracy[0] = 0;
            aux_accuracy[1] = 0;
            aux_pe = 0;
            aux_timelapse;
            timelapse_t[1]=0;
            timelapse_t[2]=0;
            timelapse_t[3]=0;
            ladoTimelapse = 0;
            modoTimelapse = 0;

            if((ingreso_app == '$')||(ingreso_app == 'S')||(ingreso_app == 'V')||(ingreso_app == 'J')||(ingreso_app == 'L')||(ingreso_app == 'P')||(ingreso_app == 'T')) {
                if(ingreso_app == 'S') {
                    estado_recepcion_app = S1;
                }
                if(ingreso_app == 'V') {
                    estado_recepcion_app = V1;
                }
                if(ingreso_app == 'J') {
                    estado_recepcion_app = HAB_JOYSTICK;
                }
                if(ingreso_app == 'L') {
                    estado_recepcion_app = LOOP_HAB;
                }
                if(ingreso_app == 'T') {
                    estado_recepcion_app = TIMELAPSE;
                }
                if(ingreso_app == 'P') {
                    estado_recepcion_app = PUNTOE;
                    aux_pe = 1;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;

        case S1:

            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    estado_recepcion_app = S2;
                    //RECIBO PRIMER DIGITO
                    aux_slide[0] = ingreso_app;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;

        case S2:

            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    estado_recepcion_app = S3;
                    //RECIBO SEGUNDO DIGITO
                    aux_slide[1] = ingreso_app;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;

        case S3:

            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    estado_recepcion_app = TILT;
                    //RECIBO TERCER DIGITO
                    aux_slide[2] = ingreso_app;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case TILT:

            if((ingreso_app == '$')||(ingreso_app == 'T')) {
                if(ingreso_app == 'T') {
                    estado_recepcion_app = T1;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;

        case T1:

            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    estado_recepcion_app = T2;
                    //RECIBO PRIMER DIGITO
                    aux_tilt[0] = ingreso_app;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;

        case T2:

            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    estado_recepcion_app = T3;
                    //RECIBO SEGUNDO DIGITO
                    aux_tilt[1] = ingreso_app;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;

        case T3:

            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    estado_recepcion_app = PAN;
                    //RECIBO TERCER DIGITO
                    aux_tilt[2] = ingreso_app;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;

        case PAN:

            if((ingreso_app == '$')||(ingreso_app == 'P')) {
                if(ingreso_app == 'P') {
                    estado_recepcion_app = P1;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;

        case P1:

            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    estado_recepcion_app = P2;
                    //RECIBO PRIMER DIGITO
                    aux_pan[0] = ingreso_app;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;

        case P2:

            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    estado_recepcion_app = P3;
                    //RECIBO SEGUNDO DIGITO
                    aux_pan[1] = ingreso_app;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;

        case P3:

            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    estado_recepcion_app = CRC;
                    //RECIBO TERCER DIGITO
                    aux_pan[2] = ingreso_app;
                    trama_recibida = VALORES_MOTOR;

                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case V1:
            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='1'))) {
                if((ingreso_app>='0')&&(ingreso_app<='1')) {
                    estado_recepcion_app = V2;
                    //RECIBO PRIMER DIGITO
                    aux_vel[0] = ingreso_app;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case V2:

            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    estado_recepcion_app = CRC;
                    //RECIBO SEGUNDO DIGITO
                    aux_vel[1] = ingreso_app;
                    trama_recibida = VELOCIDAD_MOTOR;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case HAB_JOYSTICK:

            if((ingreso_app == '$')||(ingreso_app=='A')||(ingreso_app=='R')) {
                if(ingreso_app == 'A') {
                    estado_recepcion_app = CRC;
                    trama_recibida = MODO_DE_CONTROL;
                    //RECIBO VALOR
                    aux_modo = APP;

                }
                if(ingreso_app == 'R') {
                    estado_recepcion_app = CRC;
                    trama_recibida = MODO_DE_CONTROL;
                    //RECIBO VALOR
                    aux_modo = CONTROL;

                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case LOOP_HAB:
            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='1'))) {
                if(ingreso_app=='0') {
                    aux_loop = DESHABILITADO;
                    estado_recepcion_app = CRC;
                    trama_recibida = CONF_LOOP;
                    //RECIBO PRIMER DIGITO
                }
                if(ingreso_app=='1') {
                    aux_loop = HABILITADO;
                    estado_recepcion_app = L_DELAY1;
                    //RECIBO PRIMER DIGITO
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case L_DELAY1:
            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    t_delay[1] = ingreso_app;
                    estado_recepcion_app = L_DELAY2;
                    //RECIBO PRIMER DIGITO
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case L_DELAY2:
            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    t_delay[2] = ingreso_app;
                    estado_recepcion_app = LD_UNIDAD;
                    //RECIBO PRIMER DIGITO
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case LD_UNIDAD:
            if((ingreso_app == '$')||(ingreso_app>='S')||(ingreso_app<='M')||(ingreso_app<='H')) {
                if(ingreso_app=='S') {
                    t_delay[3] = SEGUNDOS;
                    estado_recepcion_app = L_TIMEOUT1;
                    //RECIBO PRIMER DIGITO
                }
                if(ingreso_app=='M') {
                    t_delay[3] = MINUTOS;
                    estado_recepcion_app = L_TIMEOUT1;
                    //RECIBO PRIMER DIGITO
                }
                if(ingreso_app=='H') {
                    t_delay[3] = HORAS;
                    estado_recepcion_app = L_TIMEOUT1;
                    //RECIBO PRIMER DIGITO
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case L_TIMEOUT1:
            if((ingreso_app == '$')||(ingreso_app == 'N')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    t_out[1] = ingreso_app;
                    estado_recepcion_app = L_TIMEOUT2;
                    //RECIBO PRIMER DIGITO
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
                if(ingreso_app == 'N') {
                    t_out[1] = '0';
                    estado_recepcion_app = L_TIMEOUT2;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case L_TIMEOUT2:
            if((ingreso_app == '$')||(ingreso_app == 'C')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    t_out[2] = ingreso_app;
                    estado_recepcion_app = LT_UNIDAD;
                    //RECIBO PRIMER DIGITO
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
                if(ingreso_app == 'C') {
                    t_out[2] = '0';
                    estado_recepcion_app = LT_UNIDAD;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case LT_UNIDAD:
            if((ingreso_app == '$')||(ingreso_app>='S')||(ingreso_app<='M')||(ingreso_app<='H')) {
                if(ingreso_app=='S') {
                    t_out[3] = SEGUNDOS;
                    estado_recepcion_app = CRC;
                    //RECIBO PRIMER DIGITO
                    trama_recibida = CONF_LOOP;
                }
                if(ingreso_app=='M') {
                    t_out[3] = MINUTOS;
                    estado_recepcion_app = CRC;
                    //RECIBO PRIMER DIGITO
                    trama_recibida = CONF_LOOP;
                }
                if(ingreso_app=='H') {
                    t_out[3] = HORAS;
                    estado_recepcion_app = CRC;
                    //RECIBO PRIMER DIGITO
                    trama_recibida = CONF_LOOP;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case PUNTOE:
            if((ingreso_app == '$')||(ingreso_app>='R')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    aux_accuracy[0] = ingreso_app;
                    estado_recepcion_app = PRECISION;

                }
                if(ingreso_app>='R') {
                    aux_pe = DESHABILITADO;
                    estado_recepcion_app = CRC;
                    trama_recibida = PUNTO_E;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case PRECISION:
            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    aux_accuracy[1] = ingreso_app;
                    estado_recepcion_app = CRC;
                    aux_pe = HABILITADO;
                    trama_recibida = PUNTO_E;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;

        case TIMELAPSE:
            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='1'))) {
                if(ingreso_app=='0') {
                    //aux_accuracy[1] = ingreso_app;
                    estado_recepcion_app = CRC;
                    aux_timelapse = DESHABILITADO;
                    trama_recibida = TIME_LAPSE;
                }
                if(ingreso_app=='1') {
                    estado_recepcion_app = T_DURACION;
                    aux_timelapse = HABILITADO;
                    trama_recibida = TIME_LAPSE;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;

        case T_DURACION:
            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    //aux_accuracy[1] = ingreso_app;
                    estado_recepcion_app = T_DURACION2;
                    timelapse_t[1] = ingreso_app;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case T_DURACION2:
            if((ingreso_app == '$')||((ingreso_app>='0')&&(ingreso_app<='9'))) {
                if((ingreso_app>='0')&&(ingreso_app<='9')) {
                    //aux_accuracy[1] = ingreso_app;
                    estado_recepcion_app = T_UNIDAD;
                    timelapse_t[2] = ingreso_app;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case T_UNIDAD:
            if((ingreso_app == '$')||(ingreso_app == 'S')||(ingreso_app == 'M')||(ingreso_app == 'H')) {
                if(ingreso_app == 'S') {
                    //aux_accuracy[1] = ingreso_app;
                    estado_recepcion_app = T_LADO;
                    timelapse_t[3] = SEGUNDOS;
                }
                if(ingreso_app == 'M') {
                    //aux_accuracy[1] = ingreso_app;
                    estado_recepcion_app = T_LADO;
                    timelapse_t[3] = MINUTOS;
                }
                if(ingreso_app == 'H') {
                    //aux_accuracy[1] = ingreso_app;
                    estado_recepcion_app = T_LADO;
                    timelapse_t[3] = HORAS;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case T_LADO:
            if((ingreso_app == '$')||(ingreso_app == 'I')||(ingreso_app == 'D')) {
                if(ingreso_app == 'D') {
                    //aux_accuracy[1] = ingreso_app;
                    estado_recepcion_app = T_MODO;
                    ladoTimelapse = DERECHA;
                }
                if(ingreso_app == 'I') {
                    //aux_accuracy[1] = ingreso_app;
                    estado_recepcion_app = T_MODO;
                    ladoTimelapse = IZQUIERDA;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case T_MODO:
            if((ingreso_app == '$')||(ingreso_app == 'P')||(ingreso_app == 'E')||(ingreso_app == 'M')) {
                if(ingreso_app == 'P') {
                    //aux_accuracy[1] = ingreso_app;
                    estado_recepcion_app = CRC;
                    modoTimelapse = 1;
                }
                if(ingreso_app == 'M') {
                    //aux_accuracy[1] = ingreso_app;
                    estado_recepcion_app = CRC;
                    modoTimelapse = 2;
                }
                if(ingreso_app == 'H') {
                    //aux_accuracy[1] = ingreso_app;
                    estado_recepcion_app = CRC;
                    modoTimelapse = 3;
                }
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
            } else {
                estado_recepcion_app = START;
            }
            break;
        case CRC:
            //Guardo valor CRC
            crc = ingreso_app;
            estado_recepcion_app = FIN;
            break;
        case FIN:

            if((ingreso_app == '$')||(ingreso_app == '!')) {
                if(ingreso_app == '$') {
                    estado_recepcion_app = INICIO;
                }
                if(ingreso_app == '!') {
                    if(crc == 'e') {
                        if(trama_recibida == CONF_LOOP) {
                            loop = aux_loop;
                            estado_maq_loop = ESPERO;
                            loopRetraso = ((t_delay[1]-0x30)*10+(t_delay[2]-0x30));
                            loopRetrasoUnidadDeTiempo = t_delay[3];
                            loopDetenerseUnidadDeTiempo = t_out[3];
                            loopDetenerse = ((t_out[1]-0x30)*10+(t_out[2]-0x30));
                            if(loopDetenerse != 0) {
                                switch(loopDetenerseUnidadDeTiempo) {
                                    case SEGUNDOS:
                                        desactivar_loop.attach(&off_loop,loopDetenerse);
                                        break;
                                    case MINUTOS:
                                        desactivar_loop.attach(&off_loop,loopDetenerse*60);
                                        break;
                                    case HORAS:
                                        desactivar_loop.attach(&off_loop,loopDetenerse * 60); // Falta multiplicar por 60 mas
                                        break;
                                }
                            }
                        }
                        estado_recepcion_app = START;
                        if(trama_recibida == TIME_LAPSE) {
                            if(aux_timelapse==HABILITADO) {
                                stateTimelapse = HABILITADO;
                                tiempoTimelapse = ((timelapse_t[1]-0x30)*10+(timelapse_t[2]-0x30));;
                                unidadtiempoTimelapse = timelapse_t[3];
                                lado_Timelapse = ladoTimelapse;
                                modo_Timelapse = modoTimelapse;
                                loop = DESHABILITADO;
                                off_loop();
                            } else if(aux_timelapse==DESHABILITADO) {
                                stateTimelapse = DESHABILITADO;
                            }


                        }
                        if(trama_recibida == VALORES_MOTOR) {
                            app_VSlide = ((aux_slide[0]-0x30)*100+(aux_slide[1]-0x30)*10+(aux_slide[2]-0x30));
                            app_VTilt = ((aux_tilt[0]-0x30)*100+(aux_tilt[1]-0x30)*10+(aux_tilt[2]-0x30));
                            app_VPan = ((aux_pan[0]-0x30)*100+(aux_pan[1]-0x30)*10+(aux_pan[2]-0x30));
                        }
                        if(trama_recibida == PUNTO_E) {
                            punto_especifico = aux_pe;
                            posicion_slide = pasos_slide;
                            posicion_pan = pasos_pan;

                        }
                        if(trama_recibida == VELOCIDAD_MOTOR) {
                            intensidad_VSlide = ((aux_vel[0]-0x30)*10+(aux_vel[1]-0x30));
                        }
                        if(trama_recibida == MODO_DE_CONTROL) {
                            modo_de_funcionamiento = aux_modo;
                        }

                    }
                } else {
                    estado_recepcion_app = START;
                }
            }
            break;
    }
}
void MAQ_recepcion_control()
{
    static int aux_slide[3];
    static int aux_tilt[3];
    static int aux_pan[3];
    static int aux_botones[2];
    static int crc;

    switch(estado_recepcion_control) {
        case START:

            // Reseteo todas las variables
            aux_slide[0] = 0;
            aux_slide[1] = 0;
            aux_slide[2] = 0;
            aux_tilt[0] = 0;
            aux_tilt[1] = 0;
            aux_tilt[2] = 0;
            aux_pan[0] = 0;
            aux_pan[1] = 0;
            aux_pan[2] = 0;
            aux_botones[0] = 0;
            aux_botones[1] = 0;
            crc = 0;

            if(ingreso_control == '$') {
                estado_recepcion_control = SLIDE;
            }
            break;

        case SLIDE:

            if((ingreso_control == '$')||(ingreso_control == 'S')) {
                if(ingreso_control == 'S') {
                    estado_recepcion_control = S1;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;

        case S1:

            if((ingreso_control == '$')||((ingreso_control>='0')&&(ingreso_control<='9'))) {
                if((ingreso_control>='0')&&(ingreso_control<='9')) {
                    estado_recepcion_control = S2;
                    //RECIBO PRIMER DIGITO
                    aux_slide[0] = ingreso_control;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;

        case S2:

            if((ingreso_control == '$')||((ingreso_control>='0')&&(ingreso_control<='9'))) {
                if((ingreso_control>='0')&&(ingreso_control<='9')) {
                    estado_recepcion_control = S3;
                    //RECIBO SEGUNDO DIGITO
                    aux_slide[1] = ingreso_control;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;

        case S3:

            if((ingreso_control == '$')||((ingreso_control>='0')&&(ingreso_control<='9'))) {
                if((ingreso_control>='0')&&(ingreso_control<='9')) {
                    estado_recepcion_control = TILT;
                    //RECIBO TERCER DIGITO
                    aux_slide[2] = ingreso_control;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;
        case TILT:
            if((ingreso_control == '$')||(ingreso_control == 'T')) {
                if(ingreso_control == 'T') {
                    estado_recepcion_control = T1;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;

        case T1:

            if((ingreso_control == '$')||((ingreso_control>='0')&&(ingreso_control<='9'))) {
                if((ingreso_control>='0')&&(ingreso_control<='9')) {
                    estado_recepcion_control = T2;
                    //RECIBO PRIMER DIGITO
                    aux_tilt[0] = ingreso_control;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;

        case T2:

            if((ingreso_control == '$')||((ingreso_control>='0')&&(ingreso_control<='9'))) {
                if((ingreso_control>='0')&&(ingreso_control<='9')) {
                    estado_recepcion_control = T3;
                    //RECIBO SEGUNDO DIGITO
                    aux_tilt[1] = ingreso_control;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;

        case T3:

            if((ingreso_control == '$')||((ingreso_control>='0')&&(ingreso_control<='9'))) {
                if((ingreso_control>='0')&&(ingreso_control<='9')) {
                    estado_recepcion_control = PAN;
                    //RECIBO TERCER DIGITO
                    aux_tilt[2] = ingreso_control;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;
        case PAN:

            if((ingreso_control == '$')||(ingreso_control == 'P')) {
                if(ingreso_control == 'P') {
                    estado_recepcion_control = P1;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;

        case P1:

            if((ingreso_control == '$')||((ingreso_control>='0')&&(ingreso_control<='9'))) {
                if((ingreso_control>='0')&&(ingreso_control<='9')) {
                    estado_recepcion_control = P2;
                    //RECIBO PRIMER DIGITO
                    aux_pan[0] = ingreso_control;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;

        case P2:

            if((ingreso_control == '$')||((ingreso_control>='0')&&(ingreso_control<='9'))) {
                if((ingreso_control>='0')&&(ingreso_control<='9')) {
                    estado_recepcion_control = P3;
                    //RECIBO SEGUNDO DIGITO
                    aux_pan[1] = ingreso_control;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;

        case P3:

            if((ingreso_control == '$')||((ingreso_control>='0')&&(ingreso_control<='9'))) {
                if((ingreso_control>='0')&&(ingreso_control<='9')) {
                    estado_recepcion_control = BOTONES;
                    //RECIBO TERCER DIGITO
                    aux_pan[2] = ingreso_control;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;
        case BOTONES:

            if((ingreso_control == '$')||(ingreso_control == 'B')) {
                if(ingreso_control == 'B') {
                    estado_recepcion_control = B1;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;

        case B1:
            if((ingreso_control == '$')||((ingreso_control>='0')&&(ingreso_control<='9'))) {
                //if((ingreso_control == '$')||((ingreso_control>=(0b1100+0x30))&&(ingreso_control<=(0b1111+0x30)))) {
                if((ingreso_control>='0')&&(ingreso_control<='9')) {
                    estado_recepcion_control = B2;
                    //RECIBO PRIMER DIGITO
                    aux_botones[0] = ingreso_control;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;

        case B2:
            if((ingreso_control == '$')||((ingreso_control>='0')&&(ingreso_control<='9'))) {
                //if((ingreso_control == '$')||((ingreso_control>=(0b1100+0x30))&&(ingreso_control<=(0b1111+0x30)))) {
                if((ingreso_control>='0')&&(ingreso_control<='9')) {
                    estado_recepcion_control = CRC;
                    //RECIBO SEGUNDO DIGITO
                    aux_botones[1] = ingreso_control;
                }
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
            } else {
                estado_recepcion_control = START;
            }
            break;

        case CRC:

            //Guardo valor CRC
            crc = ingreso_control;
            estado_recepcion_control = FIN;

            break;

        case FIN:
            if((ingreso_control == '$')||(ingreso_control == '!')) {
                if(ingreso_control == '$') {
                    estado_recepcion_control = SLIDE;
                }
                if(ingreso_control == '!') {
                    if(crc == 'e') {
                        estado_recepcion_control = START;
                        joystick_VSlide = ((aux_slide[0]-0x30)*100+(aux_slide[1]-0x30)*10+(aux_slide[2]-0x30));
                        joystick_VTilt = ((aux_tilt[0]-0x30)*100+(aux_tilt[1]-0x30)*10+(aux_tilt[2]-0x30));
                        joystick_VPan = ((aux_pan[0]-0x30)*100+(aux_pan[1]-0x30)*10+(aux_pan[2]-0x30));
                    }
                } else {
                    estado_recepcion_control = START;
                }
            }
    }
}
