/*programme permettant de transmetre les valeur des jauges a un terminal par conection usb*/
/*Recupération : putty -> Serial -> COM"X" -> Speed = 115200*/

#include "mbed.h"
#include "HX711.h"

/* définition des constantes pour les jauges*/
#define PINSCK A5 /*Le pin A5 est l'horologe pour la transmision de données*/
#define CAL_FACT -125.794139 /*valeur permettant de convertir la valeur des jauges en gramme*/

Serial pc(USBTX, USBRX); /*Liaison série avec le pc*/

HX711 s1(A1,PINSCK),s2(A2,PINSCK),s3(A3,PINSCK),s4(A4,PINSCK); /*déclaration des 4 jauges, 1er argument l'emplacement de la jauge, 2ème signale d'horloge*/

void print_4jauges();

int main() {
        /*ajustement des facteur de calibrations*/
    s1.setScale(CAL_FACT);
    s2.setScale(CAL_FACT); 
    s3.setScale(CAL_FACT); 
    s4.setScale(CAL_FACT); 

    /*
    s1.tare();
    s2.tare();
    s3.tare();
    s4.tare();
    *//*Fonction à déclancher via une interation extérieur  */
    while(1) {
        print_4jauges();
    }
}

void print_4jauges(){
        
        double weight1, weight2, weight3, weight4, total;
        
        weight1 = s1.getGram();
        weight2 = s2.getGram();
        weight3 = s3.getGram();
        weight4 = s4.getGram();
        
        total=weight1+weight2+weight3+weight4;
        
        pc.printf("j1= %.0f j2= %.0f j3= %.0f j4= %.0f tt= %.0f\n \r", weight1,weight2,weight3,weight4,total);
} 