#include "mbed.h"
#include "RHT03.h" //Include neede to use the RHT03 lib

Serial pc(USBTX, USBRX);

int done=0;
float temp,hum;

RHT03 humtemp(p21); //Initalise the RHT03 (change pin number to the pin its connected to)

DigitalOut lysdiode(p14);

void tickerFunction() {

    //Hum & Temp
    while(!done) { //Loop keeps running until RHT03 is read succesfully
        wait(2); //Needed to make sure the sensor has time to initalise and so its not polled too quickly
        if(humtemp.readData() == RHT_ERROR_NONE) done=1; //Request data from the RHT03
    }

    done = 0;
    temp = humtemp.getTemperatureC(); //Gets the current temperature in centigrade
    hum = humtemp.getHumidity(); //Gets the current humidity in percentage

    if (hum > 50 || temp > 23) {
            lysdiode = 0;
        } else {
            lysdiode = 1;    
        }

//Print data
    pc.printf("Hum: %0.2f, Temp: %0.2f\n", hum, temp);
        
}

Ticker ticker;

int main()
{

    pc.printf("Hello\n");

    ticker.attach(&tickerFunction, 5.0); //update every 1 sec

    while (1) {
    }
}
