/**
* IO I2C_PCA9555 (Version 0.1)
*
* CT-PIM - 2015 Charles Santos
*/
#include "mbed.h"
#include "IO_PCA9555.h"

I2C I2C_PCA9555_PLC(p9, p10);
I2C I2C_PCA9555_IO(p28, p27);

int OutputP0_OutputP1[2] = {0x00,0x00};
int InputP0_InputP1[2]   = {0xFF,0xFF};
int InputP0_OutputP1[2]  = {0xFF,0x00};
int OutputP0_InputP1[2]  = {0x00,0xFF};

Serial IOpc(USBTX, USBRX); // tx, rx

#define FULL 0xFFFF

IO_PCA9555::IO_PCA9555() {

}

void IO_PCA9555::Config_PCA9555(int I2C_Bus, int I2C_PCA9555_addr0, int *Config_PCA9555) {
  
    cmd[0] = REG6;
    cmd[1] = (*Config_PCA9555);
    Config_PCA9555++;
    cmd[2] = (*Config_PCA9555);
    if (I2C_Bus == PLC) {
        I2C_PCA9555_PLC.write(I2C_PCA9555_addr0, cmd, 3);
    }
    else {
        I2C_PCA9555_IO.write(I2C_PCA9555_addr0, cmd, 3);
    }
} 

void IO_PCA9555::Write_PCA9555(int I2C_Bus, int I2C_PCA9555_addr0, int reg, int data) {
      
    cmd[0] = reg;
    cmd[1] = data;
    if (I2C_Bus == PLC) {
        I2C_PCA9555_PLC.write(I2C_PCA9555_addr0, cmd, 2);
    }
    else {
        I2C_PCA9555_IO.write(I2C_PCA9555_addr0, cmd, 2);
    }
}  

int IO_PCA9555::Read_PCA9555(int I2C_Bus, int I2C_PCA9555_addr0, int reg) {
      
    cmd[0] = reg;
    if (I2C_Bus == PLC) {
        I2C_PCA9555_PLC.write(I2C_PCA9555_addr0, cmd, 1);
        I2C_PCA9555_PLC.read(I2C_PCA9555_addr0, cmd, 1);
    }
    else {
        I2C_PCA9555_IO.write(I2C_PCA9555_addr0, cmd, 1);
        I2C_PCA9555_IO.read(I2C_PCA9555_addr0, cmd, 1);
    }
    rdata = cmd[0];
    return rdata;
}  

void IO_PCA9555::Reset_PCA9555(void){

    I2C_PCA9555_PLC.frequency(400000);
    I2C_PCA9555_IO.frequency(400000);

    Config_PCA9555(PLC, (0x20<<1), InputP0_OutputP1);
    Config_PCA9555(PLC, (0x21<<1), InputP0_OutputP1);

    Config_PCA9555(IO0, (0x20<<1), InputP0_OutputP1);
    Config_PCA9555(IO0, (0x21<<1), InputP0_OutputP1);

    Config_PCA9555(IO1, (0x22<<1), InputP0_OutputP1);
    Config_PCA9555(IO1, (0x23<<1), InputP0_OutputP1);

    Config_PCA9555(IO2, (0x24<<1), InputP0_OutputP1);
    Config_PCA9555(IO2, (0x25<<1), InputP0_OutputP1);

    Config_PCA9555(IO3, (0x26<<1), InputP0_OutputP1);
    Config_PCA9555(IO3, (0x27<<1), InputP0_OutputP1);

    Write_Word_PCA9555(PLC, (0x20<<1) , (0x21<<1), 0xFF, 0xFF);
    Write_Word_PCA9555(IO0, (0x20<<1) , (0x21<<1), 0xFF, 0xFF);
    Write_Word_PCA9555(IO1, (0x22<<1) , (0x23<<1), 0xFF, 0xFF);
    Write_Word_PCA9555(IO2, (0x24<<1) , (0x25<<1), 0xFF, 0xFF);
    Write_Word_PCA9555(IO3, (0x26<<1) , (0x27<<1), 0xFF, 0xFF);
}

void IO_PCA9555::Write_Word_PCA9555(int I2C_Bus, int I2C_PCA9555_addr0, int I2C_PCA9555_addr1,  int value1, int value2) {

    Write_PCA9555(I2C_Bus, I2C_PCA9555_addr0, REG3, value2);
    Write_PCA9555(I2C_Bus, I2C_PCA9555_addr1, REG3, value1);
}

void IO_PCA9555::Write_bit_PCA9555(int I2_Bus, int I2C_PCA9555_addr0, int I2C_PCA9555_addr1, int BitPosition, int BitValue, int reg) {

uint16_t Word;
uint8_t  value1 = 0xFF;
uint8_t  value2 = 0xFF;

        if (BitValue == 1) {
            Word = 0x0001;
            Word =~(Word << BitPosition);
            value2 = Word;
            value1 = (Word >> 8);
            value2 = (value2 & Read_PCA9555(I2_Bus, I2C_PCA9555_addr0, reg));
            value1 = (value1 & Read_PCA9555(I2_Bus, I2C_PCA9555_addr1, reg));
        }
        else {
            Word = 0x0001;
            Word =(Word << BitPosition);
            value2 = Word;
            value1 = (Word >> 8);
            value2 = (value2 | Read_PCA9555(I2_Bus, I2C_PCA9555_addr0, reg));
            value1 = (value1 | Read_PCA9555(I2_Bus, I2C_PCA9555_addr1, reg));
        }

        Write_PCA9555(I2_Bus, I2C_PCA9555_addr0, reg, value2);
        Write_PCA9555(I2_Bus, I2C_PCA9555_addr1, reg, value1);
}


bool IO_PCA9555::Read_bit_PCA9555(int I2C_Bus, int I2C_PCA9555_addr0, int I2C_PCA9555_addr1, int BitPosition, int reg) {

uint16_t Word;
uint16_t Buffer;

uint8_t value1 = 0xFF;
uint8_t value2 = 0xFF;

        Buffer = 0x0001;
        Buffer = (Buffer << BitPosition);

        value2 = ~Read_PCA9555(I2C_Bus, I2C_PCA9555_addr0, reg);
        value1 = ~Read_PCA9555(I2C_Bus, I2C_PCA9555_addr1, reg);
        Word = value1;
        Word = Word << 8;
        Word = (Word | value2);
        Word = Word & Buffer;
        if (Word == Buffer) {
        return true;}
        else {return false;}
}

void IO_PCA9555::Read_Word_PCA9555(int I2C_Bus, int I2C_PCA9555_addr0, int I2C_PCA9555_addr1, char value[3], int reg) {

    value[2] = ~Read_PCA9555(I2C_Bus, I2C_PCA9555_addr0, reg);
    value[1] = ~Read_PCA9555(I2C_Bus, I2C_PCA9555_addr1, reg);
}

void IO_PCA9555::Read_IO_bit_to_bit_and_Separates_In_a_bit_Vector(void) {

    for(int rbit = 0 ; rbit <= 79 ; rbit++) {
        bit[rbit] = Read_IO_bit_Individually(rbit);
    }
}

void IO_PCA9555::Read_IO_All_bytes_and_Separates_In_a_byte_Vector(char byte[], int reg) {

        byte[10] = ~Read_PCA9555(PLC, (0x20 << 1), reg);
        byte[9]  = ~Read_PCA9555(PLC, (0x21 << 1), reg);
        byte[8]  = ~Read_PCA9555(IO0, (0x20 << 1), reg);
        byte[7]  = ~Read_PCA9555(IO0, (0x21 << 1), reg);
        byte[6]  = ~Read_PCA9555(IO1, (0x22 << 1), reg);
        byte[5]  = ~Read_PCA9555(IO1, (0x23 << 1), reg);
        byte[4]  = ~Read_PCA9555(IO2, (0x24 << 1), reg);
        byte[3]  = ~Read_PCA9555(IO2, (0x25 << 1), reg);
        byte[2]  = ~Read_PCA9555(IO3, (0x26 << 1), reg);
        byte[1]  = ~Read_PCA9555(IO3, (0x27 << 1), reg);
}

void IO_PCA9555::Read_IO_Word_and_Separates_In_a_bit_Vector(int SelectIO) {

    int rbit;

    switch(SelectIO)
    {

    case PLC:
        for(rbit = 0 ; rbit <= 15 ; rbit++) {
            bit[rbit] = Read_bit_PCA9555(PLC, (0x20 << 1), (0x21 << 1), rbit, REG0);
        }

    case IO0:
        for(rbit = 16 ; rbit <= 31 ; rbit++)    {
            bit[rbit] = Read_bit_PCA9555(IO0, (0x20 << 1), (0x21 << 1), rbit-16, REG0);
        }

    case IO1:
        for(rbit = 32 ; rbit <= 47 ; rbit++)    {
            bit[rbit] = Read_bit_PCA9555(IO1, (0x22 << 1), (0x23 << 1), rbit-32, REG0);
        }

    case IO2:
        for(rbit = 48 ; rbit <= 63 ; rbit++)    {
            bit[rbit] = Read_bit_PCA9555(IO2, (0x24 << 1), (0x25 << 1), rbit-48, REG0);
        }

    case IO3:
        for(rbit = 64 ; rbit <= 79 ; rbit++)    {
            bit[rbit] = Read_bit_PCA9555(IO3, (0x26 << 1), (0x27 << 1), rbit-64, REG0);
        }
    }
}

bool IO_PCA9555::Read_IO_bit_Individually(int BitPosition) {

    bool rbit = 0;

    if ((BitPosition >= 0) && (BitPosition <= 15)) {
        rbit = Read_bit_PCA9555(PLC, (0x20 << 1), (0x21 << 1), BitPosition, REG0);
        }

    if ((BitPosition >= 16) && (BitPosition <= 31)) {
        rbit = Read_bit_PCA9555(IO0, (0x20 << 1), (0x21 << 1), BitPosition-16, REG0);
        }

    if ((BitPosition >= 32) && (BitPosition <= 47)) {
        rbit = Read_bit_PCA9555(IO1, (0x22 << 1), (0x23 << 1), BitPosition-32, REG0);
        }

    if ((BitPosition >= 48) && (BitPosition <= 63)) {
        rbit = Read_bit_PCA9555(IO2, (0x24 << 1), (0x25 << 1), BitPosition-48, REG0);
        }

    if ((BitPosition >= 64) && (BitPosition <= 79)) {
        rbit = Read_bit_PCA9555(IO3, (0x26 << 1), (0x27 << 1), BitPosition-64, REG0);
    }
    return rbit;
}

void IO_PCA9555::WriteIO(int SelectIO, int BitPosition, int BitValue) {

    switch(SelectIO)
    {

    case PLC:
        Write_bit_PCA9555(PLC, (0x20 << 1), (0x21 << 1), BitPosition, BitValue, REG3);

    case IO0:
        Write_bit_PCA9555(IO0, (0x20 << 1), (0x21 << 1), BitPosition-16, BitValue, REG3);

    case IO1:
        Write_bit_PCA9555(IO1, (0x22 << 1), (0x23 << 1), BitPosition-32, BitValue, REG3);

    case IO2:
        Write_bit_PCA9555(IO2, (0x24 << 1), (0x25 << 1), BitPosition-48, BitValue, REG3);

    case IO3:
        Write_bit_PCA9555(IO3, (0x26 << 1), (0x27 << 1), BitPosition-64, BitValue, REG3);
    }
}

void IO_PCA9555::Write_IO_bit_Individually(int BitPosition, int BitValue) {

    __disable_irq();
    if ((BitPosition >= 0) && (BitPosition <= 15)) {
        Write_bit_PCA9555(PLC, (0x20 << 1), (0x21 << 1), BitPosition, BitValue, REG3);
        }

    else if ((BitPosition >= 16) && (BitPosition <= 31)) {
        Write_bit_PCA9555(IO0, (0x20 << 1), (0x21 << 1), BitPosition-16, BitValue, REG3);
        }

    else if ((BitPosition >= 32) && (BitPosition <= 47)) {
        Write_bit_PCA9555(IO1, (0x22 << 1), (0x23 << 1), BitPosition-32, BitValue, REG3);
        }

    else if ((BitPosition >= 48) && (BitPosition <= 63)) {
        Write_bit_PCA9555(IO2, (0x24 << 1), (0x25 << 1), BitPosition-48, BitValue, REG3);
        }

    else if ((BitPosition >= 64) && (BitPosition <= 79)) {
        Write_bit_PCA9555(IO3, (0x26 << 1), (0x27 << 1), BitPosition-64, BitValue, REG3);
    }
    wait_ms(1);
    __enable_irq();
}

void IO_PCA9555::Test_IO_bit_Individually(){

    for(int rbit = 0 ; rbit <= 79 ; rbit++) {
        bit[rbit] = Read_IO_bit_Individually(rbit);

        if (bit[rbit]) {
            Write_IO_bit_Individually(rbit, 1);
        }
        else if (!bit[rbit]) {
            Write_IO_bit_Individually(rbit, 0);
        }
    }
}

void IO_PCA9555::Set_All_IO_bit(){

    Write_Word_PCA9555(PLC, (0x20<<1) , (0x21<<1), 0x00, 0x00);
    Write_Word_PCA9555(IO0, (0x20<<1) , (0x21<<1), 0x00, 0x00);
    Write_Word_PCA9555(IO1, (0x22<<1) , (0x23<<1), 0x00, 0x00);
    Write_Word_PCA9555(IO2, (0x24<<1) , (0x25<<1), 0x00, 0x00);
    Write_Word_PCA9555(IO3, (0x26<<1) , (0x27<<1), 0x00, 0x00);
}
