/**
 * IO I2C (Version 0.1)
 *
 * CT-PIM - 2015 Charles Santos
 */
#ifndef IO_PCA9555_H
#define IO_PCA9555_H

class IO_PCA9555 {
    
private:
    char cmd[3];  
    char rd_data;
    char rdata; 

public:

    int  I2C_PCA9555_addr0;
    int  I2C_PCA9555_addr1;

    bool bit[80];

    typedef enum {
        REG0,    //Reading Register - Port0
        REG1,    //Reading Register - Port1
        REG2,    //writing Register - Port0
        REG3,    //writing Register - Port1
        REG4,    //Polarity Inversion Register - Port0
        REG5,    //Polarity Inversion Register - Port1
        REG6,    //Configuration Register - Port0
        REG7     //Configuration Register - Port1
    } I2C_REG;

    typedef enum {

        PLC,     //PLC's IO
        IO0,     //Expansion 0
        IO1,     //Expansion 1
        IO2,     //Expansion 2
        IO3,     //Expansion 3
        IO4,     //Expansion 4
    } PCB_IO;

    IO_PCA9555(void);
    void Config_PCA9555(int, int, int *);
    void Write_PCA9555(int, int, int, int);
    int  Read_PCA9555(int, int, int);
    void Reset_PCA9555(void);
    void Write_Word_PCA9555(int, int, int, int, int);
    void Write_bit_PCA9555(int, int, int, int, int, int);
    void Read_Word_PCA9555(int, int, int, char[3], int);
    bool Read_bit_PCA9555(int, int, int, int, int);
    void Read_IO_bit_to_bit_and_Separates_In_a_bit_Vector(void);
    void Read_IO_All_bytes_and_Separates_In_a_byte_Vector(char [], int);
    void Read_IO_Word_and_Separates_In_a_bit_Vector(int);
    bool Read_IO_bit_Individually(int);
    void WriteIO(int, int, int);
    void Write_IO_bit_Individually(int, int);
    void Test_IO_bit_Individually(void);
    void Set_All_IO_bit(void);
};

#endif
