#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(D8, D9, D4, D5, D6, D7);
Serial pc(USBTX, USBRX);
Serial obd(PC_10, PC_11);

char dado[20];
int RPM=0;
float poret=0;
int velocidade=0;
int i=0;
int main()
{
    pc.baud(9600);
    
    obd.baud(38400);
    
    obd.printf("ATD\r");    wait_ms(500);
    obd.printf("ATZ\r");    wait_ms(500);
    obd.printf("ATL0\r");   wait_ms(500);
    obd.printf("ATS0\r");   wait_ms(500);
    obd.printf("ATM0\r");   wait_ms(500);
    obd.printf("ATST10\r"); wait_ms(500);
    obd.printf("ATE0\r");   wait_ms(500);
    
    while(1)
    {
        obd.printf("ATRV\r");
        i=0;
        while(!obd.readable()){} //fica esperando chegar algo na serial
        while(dado[i-1]!= '\r')        //chegou algo! vamos ler até o CR
            {
            dado[i] = obd.getc();
            i++;
            }
        //pc.printf(dado);
        lcd.locate(0,0);
        lcd.printf("%c%c%c%cV",dado[i-6],dado[i-5],dado[i-4],dado[i-3]);
        wait(0.1);   

        memset(dado,NULL,20);
        i=0;        
        obd.printf("010C\r");
        while(!obd.readable()){} //fica esperando chegar algo na serial
        while(dado[i-1]!= '\r')        //chegou algo! vamos ler até o CR
            {  
            dado[i] = obd.getc();
            i++;
            }   
        //pc.printf(dado);
        char A[2]={NULL,NULL};
        char B[2]={NULL,NULL};
        A[0] = dado[i-5];
        A[1] = dado[i-4];
     
        B[0] = dado[i-3];
        B[1] = dado[i-2];
        //pc.printf(A);
        //pc.printf(B);
        int valor_A = strtol(A,NULL,16);   
        int valor_B = strtol(B,NULL,16); 
        RPM =(((valor_A*256)+valor_B)/4);
        pc.printf("%d\r",RPM);
        lcd.locate(0,1);
        lcd.printf("%d",RPM);
        wait(0.5);

        memset(dado,NULL,20);        
        i = 0;
        obd.printf("010D\r");
        while(!obd.readable()){} //fica esperando chegar algo na serial
        while(dado[i-1]!= '\r')        //chegou algo! vamos ler até o CR
    {  
        dado[i] = obd.getc();
        i++;
    }   
        //pc.printf(dado);
        char vel[2]={NULL,NULL};
        vel[0] = dado[i-3];
        vel[1] = dado[i-2];
        //pc.printf(etA);    
        int valor_vel = strtol(vel,NULL,16);   
        velocidade =(valor_vel);
        pc.printf("%i\r",velocidade);
        lcd.locate(8,0);
        lcd.printf("%dkm/h",velocidade);
        wait(0.1);
        
        memset(dado,NULL,20);
        i=0;        
        obd.printf("0152\r");
        while(!obd.readable()){} //fica esperando chegar algo na serial
        while(dado[i-1]!= '\r')        //chegou algo! vamos ler até o CR
    {  
        dado[i] = obd.getc();
        i++;
    }   
        //pc.printf(dado);
        char etA[2]={NULL,NULL};
        etA[0] = dado[i-3];
        etA[1] = dado[i-2];
        //pc.printf(etA);    
        int valor_et = strtol(etA,NULL,16);   
        poret =((100.0f/255.0f)*valor_et);
        pc.printf("%.1f\r",poret);
        lcd.locate(0,1);
        lcd.printf("%.1f",poret);
        wait(1);
        memset(dado,NULL,20);
        lcd.cls();

    }
}  