#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(D8, D9, D4, D5, D6, D7); //rs,e,d0,d1,d2,d3
AnalogIn xAxis(A0);
AnalogIn yAxis(A1);
Serial pc(USBTX, USBRX);
CAN can1(PB_8, PB_9);

static char info[6]= {0x55, 0x54, 0x53, 0x52, 0x51, 0x50};

int main()
{
    CANMessage cima(5, &info[0], 8, CANData, CANStandard);
    CANMessage baixo(5, &info[1], 8, CANData, CANStandard);
    CANMessage esquerda(5, &info[2], 8, CANData, CANStandard);
    CANMessage direita(5, &info[3], 8, CANData, CANStandard);
    CANMessage parado(5, &info[4], 8, CANData, CANStandard);
    CANMessage ativar(5, &info[5], 8, CANData, CANStandard);
    
    int x,y;
    lcd.locate(3,0);
    lcd.printf("Retrovisor");
    
    while(1)
    {
        wait(0.1);
        can1.write(ativar);
        x = xAxis.read()*1000; // float (0 -> 1) to int (0 -> 1000)
        y = yAxis.read()*1000;
        if (x < 200){
            can1.write(esquerda);
            }
        if (x > 800){
            can1.write(direita);
            }
        if (y < 200){
            can1.write(baixo);
            }
        if (y > 800){
            can1.write(cima);
            }
        if (x > 300 && x < 700 && y > 300 && y < 700){
            can1.write(parado);
            }
            
            if(can1.read(ativar)){
                if (ativar.data[0] == 0x55){
                    lcd.locate(5,1);
                    lcd.printf("Cima        ");
                    pc.printf("Cima");
                    }
                if (ativar.data[0] == 0x54){
                    lcd.locate(5,1);
                    lcd.printf("Baixo       ");
                    pc.printf("Baixo");
                    }
                if (ativar.data[0] == 0x53){
                    lcd.locate(5,1);
                    lcd.printf("Direita      ");
                    pc.printf("Direita");
                    }
                if (ativar.data[0] == 0x52){
                    lcd.locate(5,1);
                    lcd.printf("Esquerda");
                    pc.printf("Esquerda      ");
                    }
                if (ativar.data[0] == 0x51){
                    lcd.locate(5,1);
                    lcd.printf("Parado       ");
                    pc.printf("Parado");
                    }
                ativar.data[0]=0;
                wait(0.1);
            }
        }
}