/****************************************
 * AirMouse em FRDM - KL25Z
 * Utiliza os movimentos do acelerômetro nos
 * eixos x e y para movimentar o cursor e o
 * touch capacitivo como os botôes esquerdo
 * e direito. Também possui a função de scroll
 * utilizando o touch e o acelerômetro.
 *
 * Projeto feito por Matheus Bordin Gomes
 ****************************************/
 
#include "mbed.h"
#include "USBMouse.h" //Parte da biblioteca "USBDevice"
#include "MMA8451Q.h" //Biblioteca para utilizar o acelerômetro
#include "TSISensor.h" //Biblioteca do sensor touch capacitivo

#define MMA8451_I2C_ADDRESS (0x1d<<1)

USBMouse mouse;
TSISensor tsi;
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

DigitalOut ledRight(LED_RED);
DigitalOut ledLeft(LED_BLUE);
DigitalOut working(LED_GREEN);

int main(){  
    float click = 0; //Representa os botões do mouse
    int16_t x = 0; //Representa a coordenada x do cursor
    int16_t y = 0; //Representa a coordenada y do cursor
    int16_t scroll = 0; //Representa a velocidade de scroll
    
    ledRight = 1; //Led de status do botão direito
    ledLeft = 1; //Led de status do botão esquerdo
    working = 0; //Led de status do mouse

    while (true){
        x = -9.8 * acc.getAccY(); //Leitura do acelerômetro em y para o 'x'
        y = 9.8 * acc.getAccX(); //Leitura do acelerômetro em x pra o 'y'
        scroll = 1.8 * acc.getAccX(); //Leitura do acelerômetro em y para scroll
        
        click = tsi.readPercentage(); //Leitura do touch capacitivo
        
        /**
         * Implementa a movimentação do cursor com base
         * nos movimentos de rotação do microcontrolador
         * nos eixos x e y.
         **/
        mouse.move(x, y);
            
       /**
         * Implementa o botão direito do mouse
         * na parte direita do touch capacitivo.
         * Também acende o led amarelo para mostrar
         * que o botão está pressionado.
         **/    
        if((click<0.30) && (click>0)){
            mouse.press(MOUSE_RIGHT);
            working = 1;
            ledRight = 0; 
        } else{
            mouse.release(MOUSE_RIGHT);
            ledRight = 1;
            working = 0;
        }
        
        wait(0.001);
       
        /**
         * Implementa o botão esquerdo do mouse
         * na parte esquerda do touch capacitivo.
         * Também acende o led azul para mostrar
         * que o botão está pressionado.
         **/
        if (click>0.70){
            mouse.press(MOUSE_LEFT);
            working = 1;
            ledLeft = 0;           
        } else{
            mouse.release(MOUSE_LEFT);
            ledLeft = 1;
            working = 0;
        }
        
        wait(0.001);
        
        /**
         * Implementa o scroll na parte central
         * do touch capacitivo.
         * Também acende o led rosa para mostrar
         * que o scroll está em funcionamento.
         **/ 
        if((click>0.35) && (click<0.65)){
            mouse.scroll(scroll);
            working = 1;
            ledRight = 0;
            ledLeft = 0;
        } else{
            ledRight = 1;
            ledLeft = 1;
            working = 0;
        }
            
        wait(0.001);
    }
}