//ARIAS - MARAS 6°B Tec
#include "mbed.h"
#define CANT_PULSADORES 5
#define BASE_TIEMPO     0.001

enum
{
    SUELTO, QUIZA_PRESIONADO, PRESIONADO, QUIZA_SUELTO
};
BusIn pulsadores(PTA13, PTD5, PTD0, PTD2, PTD3);
int salidas[CANT_PULSADORES];

BusOut led(PTC12, PTC13, PTC16, PTC17);

Serial pc(USBTX, USBRX);

DigitalOut ledR(PTD6);
DigitalOut ledV(PTD7);

Ticker tim;
int time_puls[CANT_PULSADORES] = {0};
int trand=1234;
int tled=1000;

void juego(void);

int Debounce(int index);

void TimerDecremento(void)
{
    if(tled > 0)
        tled--;

    for(int i = 0; i < CANT_PULSADORES; i++)
        if (time_puls[i] > 0)
            time_puls[i]--;
    trand++;//tiempo para que al usar rand cambie la semilla
    if(trand>=12345)
        trand=1234;
}

int sec[24]= {0}; //secuancia para el juego
int nivel=0;//cantidad de niveles completados
int x=1;
int main()
{
    ledR=1;
    ledV=1;
    tim.attach(&TimerDecremento, BASE_TIEMPO);
    
    pulsadores[0].mode(PullNone);
    pulsadores[1].mode(PullNone);
    pulsadores[2].mode(PullNone);
    pulsadores[3].mode(PullNone);
    pulsadores[4].mode(PullNone);

    while(1)
    {
        juego();
        for(int i = 0; i < CANT_PULSADORES; i++)
        {
            salidas[i] = Debounce(i);
        }
    }
}


void juego(void)
{
    static int i=0;//nivel actual
    static int estadoled = 5;
    static int a = 0;//valor del nivel actual
    switch(estadoled)
    {
    case 0://INICIO
        ledR=1;
        nivel++;
        estadoled=1;
        tled=500;
        pc.printf("----------------\n");
        if(nivel==25)//DETECTA SI HICIMOS LOS 24 PUNTOS
            estadoled=6;
        break;

    case 1://led apagado
        led = 0;//apaga el led despues de mostrarlo durante 500ms
        if(tled==0)
        {
            tled=500;
            estadoled=2;
        }
        break;

    case 2://muestra led
        a = sec[i];
        led[a]=1;//muestra la secuencia a pulsar, el led se enciende por 500ms
        if(x==0)//para que solo se envie 1 vez al hercules
        {
            if(a==0)
            pc.printf("ROJO\n");
            if(a==1)
            pc.printf("VERDE\n");
            if(a==2)
            pc.printf("AZUL\n");
            if(a==3)
            pc.printf("AMARILLO\n");
            x=1;
        }
        if(tled==0)
        {
            tled=500;
            i++;

            if(i==nivel)//si ya mostro todos los colores pasa al siguiente estado
            {
                estadoled=3;
                i=0;
                x=0;
            }

            else//si le falta algun o varios colores pasa al estado anterior para mostrar el siguiente
            {
                estadoled=1;
                x=0;
            }

        }
        break;


    case 3://Ingresa secuencia
        led = 0;
        a = sec[i];

        if(Debounce(a)==1)//si se presiona el boton correcto el programa sigue
        {
            i++;
            estadoled=4;
            tled=500;
        }

        if((Debounce(0)==1 || Debounce(1)==1 || Debounce(2)==1 || Debounce(3)==1)&&Debounce(a)==0)//si falla vuelve al estado apagado
        {
            estadoled=5;
        }

        break;


    case 4://Indica led Pulsado
        led[a] = 1;//el led pulsado se enciende durante 500ms
        if(tled==0)
        {
            if(i==nivel)//si se ingreso toda la secuencia correctamente vuelve al estado inicial
            {
                estadoled=0;
                i=0;
            }

            else//si falta ingresar algun color de la secuencia vuelve al paso anterior
                estadoled=3;
        }
        break;

    case 5: //CASO OFF/PIERDE
        ledV=1;
        ledR=0;
        led=0;
        i=0;
        nivel=0;
        a=0;
        
        if(x==0)
        {
            pc.printf("\n");
            pc.printf("Usted Perdio, presione en pulsador de inicio para volver a jugar\n");
            x=1;
        }
        
        if(Debounce(4)==1 && tled==0)//SI PRESIONAMOS EL 5° PULSADOR
        {
            srand((unsigned)trand);//CAMBIA LA SEMILLA DEL RAND EN BASE A UN CONTADOR QUE VA CONTANDO CONSTANTEMENTE, POR LO QUE SIEMPRE SERA DIFERENTE
            for(int r=0; r<24; r++)
            {
                sec[r]=(rand() % 4);//GENRA LOS 24 NÚMEROS ALEATORIOS
            }
            estadoled=0;
            x=0;
        }
        break;

    case 6: //CASO GANA
        led=0;
        ledV=0;
                if(x==0)
        {
            pc.printf("Usted a Ganado, lo felicitamos\n");
            pc.printf("Presione para volver al estado inicial\n");
            x=1;
        }
        if(Debounce(4)==1)//si presionamos el pulsador 5 vuelve al estado apagado
        {
            estadoled=5;
            tled=100;
        }
        break;
    }
}


// ANTIRREBOTE //

int Debounce(int index)
{

    int Estado = 0;
    static int DEBOUNCE_estado[CANT_PULSADORES] = {SUELTO};
    switch (DEBOUNCE_estado[index])
    {
    case SUELTO:
        Estado = 0;
        if (pulsadores[index] == 1)
        {
            DEBOUNCE_estado[index] = QUIZA_PRESIONADO;
            time_puls[index] = 30;
        }
        break;
    case QUIZA_PRESIONADO:
        if (time_puls[index] == 0)
        {
            if (pulsadores[index] == 1)
            {
                DEBOUNCE_estado[index] = PRESIONADO;
            }
            if (pulsadores[index] == 0)
            {
                DEBOUNCE_estado[index] = SUELTO;
            }
        }
        break;
    case PRESIONADO:
        Estado = 1;
        if (pulsadores[index] == 0)
        {
            DEBOUNCE_estado[index] = QUIZA_SUELTO;
            time_puls[index] = 30;
        }
        break;
    case QUIZA_SUELTO:
        if (time_puls[index] == 0)
        {
            if (pulsadores[index] == 0)
            {
                DEBOUNCE_estado[index] = SUELTO;
            }
            if (pulsadores[index] == 1)
            {
                DEBOUNCE_estado[index] = PRESIONADO;
            }
        }
        break;
    }
    return Estado;
}
