#include "mbed.h"
#include "epd1in54b.h"
// Control
PinName rst;
PinName dc;
PinName busy;
// SPI communication
PinName mosi;
PinName miso;
PinName sclk;
PinName cs;

DigitalOut myled(LED1);

unsigned char frame_black[EPD_HEIGHT*EPD_WIDTH/8];
unsigned char frame_red[EPD_HEIGHT*EPD_WIDTH/8];


int main() {
    mosi = p5;
    miso = p6;
    sclk = p7;
    cs = p8;
    rst = p9;
    dc = p10;
    busy = p11;
    
    memset(frame_black, 0xFF, sizeof(unsigned char)*EPD_HEIGHT*EPD_WIDTH/8);
    memset(frame_red, 0xFF, sizeof(unsigned char)*EPD_HEIGHT*EPD_WIDTH/8);

    Epd epd = Epd(mosi, miso, sclk, cs, dc, rst, busy);
    if (epd.Init() != 0){
        return -1;
    }

    /* Draw something to the frame buffer */
    // For simplicity, the arguments are explicit numerical coordinates
    epd.DrawRectangle(frame_black, 10, 60, 50, 110, COLORED);
    epd.DrawLine(frame_black, 10, 60, 50, 110, COLORED);
    epd.DrawLine(frame_black, 50, 60, 10, 110, COLORED);
    epd.DrawCircle(frame_black, 120, 80, 30, COLORED);
    epd.DrawFilledRectangle(frame_red, 10, 130, 50, 180, COLORED);
    epd.DrawFilledRectangle(frame_red, 0, 6, 200, 26, COLORED);
    epd.DrawFilledCircle(frame_red, 120, 150, 30, COLORED);

    /*Write strings to the buffer */
    epd.DrawStringAt(frame_black, 30, 30, "e-Paper Demo", &Font16, COLORED);
    epd.DrawStringAt(frame_red, 28, 10, "Hello world!", &Font16, UNCOLORED);
    
    // display images
    epd.DisplayFrame(frame_black, frame_red);
    //epd.DisplayFrame(IMAGE_BLACK, IMAGE_RED);
    epd.Sleep();

    
    while(1) {
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
    }
}