#ifndef MKVOLTAGEREG_H 
#define MKVOLTAGEREG_H

#include "analogAverager.h"
#include "analogMinMax.h"
#include "counterMinMax.h"

class voltageRegulator
{  
        struct analog1Sample {
            char analogName[6];
            float analog1Value;
        };
        struct analog2Sample {
            char analogName[6];
            float analog1Value;
            float analog2Value;
        };
        struct analog3Sample {
            char analogName[6];
            float analog1Value;
            float analog2Value;
            float analog3Value;
        };
        struct analog4Sample {
            char analogName[6];
            float analog1Value;
            float analog2Value;
            float analog3Value;
            float analog4Value;
        };
        
        struct fmTimeStamp {
            char month;
            char day;
            char year;
            char hour;
            char min;
            char sec;
            short msec;
        };
        
        struct vRegDataStruct {
            char numAnalog;
            char numDigital;
            char numDemAnalog;
            char fmMsgLen[5];
            struct analog1Sample analogs[27];
            struct analog1Sample calculated[14];
            struct fmTimeStamp timeStamp;
            struct fmTimeStamp  demTimeStamp;
            char digitalTargets[52];
            char statCounters[8];
            bool stats[3];   
        } vRegData;
        
    public:
    
        voltageRegulator(void);
        
        void setMeterData(char *cbuf, char pos, char clen);
        
        void setDemMeterData(char *cbuf, char pos, char clen);
        
        void incCount(void);
        
        char getCount(char);
        
        bool chkCfgMsg(char *cbuf, char clen);
        
        bool chkMeterMsg(char *cbuf, char clen);
        
        bool chkDemMeterMsg(char *cbuf, char clen);
        
        char getMeterReport(char *dataStr);
        
        char * getTargets(void);
};
#endif