#include "voltageRegulator.h"
#include "string.h"
#include "netDataTypes.h"
#include "mbed.h"

analogAverager voltageAvg(120,true,true,0.9,true,true,1.1);
analogMinMax voltageMinMax(120,true,true,0.9,true,true,1.1);
analogAverager currentAvg(50,true,false,-100,true,false,100);
analogMinMax currentMinMax(50,true,false,-100,true,false,100);
analogAverager powerAvg(360000,true,false,720000,true,false,720000);
analogMinMax powerMinMax(360000,true,false,-720000,true,false,720000);
analogAverager reactiveAvg(0,true,false,-360000,true,false,360000);
analogMinMax reactiveMinMax(0,true,false,-360000,true,false,360000);
counterMinMax tapMinMax(0,true,-16,true,16);

voltageRegulator::voltageRegulator()
{
    char scx;
    
    vRegData.numAnalog=0x11;
    vRegData.numDigital=0x34;
    vRegData.numDemAnalog=0x0A;
    vRegData.fmMsgLen[0]=22;//Minus Checksum
    vRegData.fmMsgLen[1]=203;//Minus Checksum
    vRegData.fmMsgLen[2]=132;//Minus Checksum
    vRegData.fmMsgLen[3]=126;//Minus Checksum
    vRegData.fmMsgLen[4]=52;//Minus Checksum
    strcpy(vRegData.analogs[0].analogName,"IL\0\0\0\0");
    strcpy(vRegData.analogs[1].analogName,"ILA\0\0\0");
    strcpy(vRegData.analogs[2].analogName,"VS\0\0\0\0");
    strcpy(vRegData.analogs[3].analogName,"VSA\0\0\0");
    strcpy(vRegData.analogs[4].analogName,"VL\0\0\0\0");
    strcpy(vRegData.analogs[5].analogName,"VLA\0\0\0");
    strcpy(vRegData.analogs[6].analogName,"VCMP\0\0");
    strcpy(vRegData.analogs[7].analogName,"TAPPOS");
    strcpy(vRegData.analogs[8].analogName,"VSSEC\0");
    strcpy(vRegData.analogs[9].analogName,"VLSEC\0");
    strcpy(vRegData.analogs[10].analogName,"VCMPSC");
    strcpy(vRegData.analogs[11].analogName,"PL\0\0\0\0");
    strcpy(vRegData.analogs[12].analogName,"QL\0\0\0\0");
    strcpy(vRegData.analogs[13].analogName,"SL\0\0\0\0");
    strcpy(vRegData.analogs[14].analogName,"PF\0\0\0\0");
    strcpy(vRegData.analogs[15].analogName,"PFLD\0\0");
    strcpy(vRegData.analogs[16].analogName,"FREQ\0\0");
    strcpy(vRegData.analogs[17].analogName,"ILFDEM");
    strcpy(vRegData.analogs[18].analogName,"ILRDEM");
    strcpy(vRegData.analogs[19].analogName,"PFDEM\0");
    strcpy(vRegData.analogs[20].analogName,"PRDEM\0");
    strcpy(vRegData.analogs[21].analogName,"QFODEM");
    strcpy(vRegData.analogs[22].analogName,"QFIDEM");
    strcpy(vRegData.analogs[23].analogName,"QRODEM");
    strcpy(vRegData.analogs[24].analogName,"QRIDEM");
    strcpy(vRegData.analogs[25].analogName,"SFDEM\0");
    strcpy(vRegData.analogs[26].analogName,"SRDEM\0");
    strcpy(vRegData.calculated[0].analogName,"VLSMIN");
    strcpy(vRegData.calculated[1].analogName,"VLSAVG");
    strcpy(vRegData.calculated[2].analogName,"VLSMAX");
    strcpy(vRegData.calculated[3].analogName,"ILMIN\0");
    strcpy(vRegData.calculated[4].analogName,"ILAVG\0");
    strcpy(vRegData.calculated[5].analogName,"ILMA\0");
    strcpy(vRegData.calculated[6].analogName,"PLMIN\0");
    strcpy(vRegData.calculated[7].analogName,"PLAVG\0");
    strcpy(vRegData.calculated[8].analogName,"PLMAX\0");
    strcpy(vRegData.calculated[9].analogName,"QLMIN\0");
    strcpy(vRegData.calculated[10].analogName,"QLAVG\0");
    strcpy(vRegData.calculated[11].analogName,"QLMAX\0");
    strcpy(vRegData.calculated[12].analogName,"TAPMIN");
    strcpy(vRegData.calculated[13].analogName,"TAPMAX");
    for (scx=0;scx<8;scx++)
    {
        vRegData.statCounters[scx]=0;
    }
    for (scx=0;scx<3;scx++)
    {
        vRegData.stats[scx]=false;
    }
}

bool voltageRegulator::chkCfgMsg(char *cbuf, char clen)
{
    char txc;
    char chksum=0;
    if (clen>vRegData.fmMsgLen[0])
    {
        for (txc=0;txc<vRegData.fmMsgLen[0];txc++)
        {
            chksum=chksum+cbuf[txc];
        }
        if (chksum==cbuf[vRegData.fmMsgLen[0]])
        {
            printf("Chksum: %02x\r\n",chksum);
            return true;
        }
        printf("Chksum Error: %02x, Message: %02x\r\n",chksum,cbuf[vRegData.fmMsgLen[0]]);
        return false;
    }
    printf("Message Length Wrong: %d Bytes\r\n",clen);
    return false;
}

void voltageRegulator::setMeterData(char *cbuf, char pos, char clen)
{
    float4byte valpack;
    short2byte timepack;
    char txc;
    char anum=pos+4;
    
    char chksum=0;
    if (clen>vRegData.fmMsgLen[2])
    {
        for (txc=0;txc<vRegData.fmMsgLen[2];txc++)
        {
            chksum=chksum+cbuf[txc];
        }
        if (chksum==cbuf[vRegData.fmMsgLen[2]])
        {
            printf("Chksum: %02x\r\n",chksum);
        }
        else
        {
            printf("Chksum Error: %02x, Message: %02x\r\n",chksum,cbuf[vRegData.fmMsgLen[2]]);
            return;
        }
    }
    else
    {
        printf("Message Length Wrong: %d Bytes\r\n",clen);
        return;
    }
    
    for (txc=0;txc<vRegData.numAnalog;txc++)
    {
        valpack.bytes[3]=cbuf[anum];
        valpack.bytes[2]=cbuf[anum+1];
        valpack.bytes[1]=cbuf[anum+2];
        valpack.bytes[0]=cbuf[anum+3];
        vRegData.analogs[txc].analog1Value = valpack.cmdflt;
        anum = anum + 4;
        //printf("%.2f\r\n",vRegData.analogs[txc].analog1Value);
    }
    vRegData.timeStamp.month=cbuf[anum];
    vRegData.timeStamp.day=cbuf[anum+1];
    vRegData.timeStamp.year=cbuf[anum+2];
    vRegData.timeStamp.hour=cbuf[anum+3];
    vRegData.timeStamp.min=cbuf[anum+4];
    vRegData.timeStamp.sec=cbuf[anum+5];
    timepack.bytes[1]=cbuf[anum+6];
    timepack.bytes[0]=cbuf[anum+7];
    vRegData.timeStamp.msec=timepack.cmdshort;
    //printf("%d/%d/%d %d:%d:%d.%d\r\n",vRegData.timeStamp.month,vRegData.timeStamp.day,vRegData.timeStamp.year,vRegData.timeStamp.hour,vRegData.timeStamp.min,vRegData.timeStamp.sec,vRegData.timeStamp.msec);
    anum=anum+8;
    for (txc=0;txc<vRegData.numDigital;txc++)
    {
        switch (txc)
        {
            case 0:
                //Check to see if the panel is reporting a voltage reduction scheme has initiated
                if ((((cbuf[anum+txc]) & (0x08)) ? true : false) && (((vRegData.digitalTargets[txc]) & (0x08)) ? false : true))
                {
                    vRegData.statCounters[4]++;
                }
                //Check to see if the panel is reporting tap position changed to neutral
                if ((((cbuf[anum+txc]) & (0x01)) ? true : false) && (((vRegData.digitalTargets[txc]) & (0x01)) ? false : true))
                {
                    vRegData.statCounters[5]++;
                }
                break;
            case 3:
                //Check to see if panel was placed into remote operation
                if ((((cbuf[anum+txc]) & (0x80)) ? true : false) && (((vRegData.digitalTargets[txc]) & (0x80)) ? false : true))
                {
                    vRegData.statCounters[0]++;
                }
                //Check to see if the panel was placed into local operation
                if ((((cbuf[anum+txc]) & (0x40)) ? true : false) && (((vRegData.digitalTargets[txc]) & (0x40)) ? false : true))
                {
                    vRegData.statCounters[1]++;
                }
                //Check to see if the panel was placed into automatice operation
                if ((((cbuf[anum+txc]) & (0x20)) ? true : false) && (((vRegData.digitalTargets[txc]) & (0x20)) ? false : true))
                {
                    vRegData.statCounters[2]++;
                }
                //Check to see if the panel was placed into manual operation
                if ((((cbuf[anum+txc]) & (0x10)) ? true : false) && (((vRegData.digitalTargets[txc]) & (0x10)) ? false : true))
                {
                    vRegData.statCounters[3]++;
                }
                break;
            case 8:
                if ((((cbuf[anum+txc]) & (0x20)) ? true : false) && (((vRegData.digitalTargets[txc]) & (0x20)) ? false : true))
                {
                    vRegData.statCounters[6]++;
                }
                if ((((cbuf[anum+txc]) & (0x10)) ? true : false) && (((vRegData.digitalTargets[txc]) & (0x10)) ? false : true))
                {
                    vRegData.statCounters[7]++;
                }
                break;
            case 9:
                //Alert if tap position is off
                vRegData.stats[0]=(((cbuf[anum+txc]) & (0x80)) ? true : false);
                //Alert if there is no neutral detected (neutral limit switch bad or wire broken)
                vRegData.stats[1]=(((cbuf[anum+txc]) & (0x40)) ? true : false);
                //Alert if Tap position is not as expected
                vRegData.stats[2]=(((cbuf[anum+txc]) & (0x20)) ? true : false);
                break;
            default:
                break;
        }
        vRegData.digitalTargets[txc]=cbuf[anum+txc];
    }
    tapMinMax.putVal(vRegData.analogs[7].analog1Value);
    voltageMinMax.putVal(vRegData.analogs[9].analog1Value);
    voltageAvg.putVal(vRegData.analogs[9].analog1Value);
    currentMinMax.putVal(vRegData.analogs[0].analog1Value);
    currentAvg.putVal(vRegData.analogs[0].analog1Value);
    powerMinMax.putVal(vRegData.analogs[11].analog1Value);
    powerAvg.putVal(vRegData.analogs[11].analog1Value);
    reactiveMinMax.putVal(vRegData.analogs[12].analog1Value);
    reactiveAvg.putVal(vRegData.analogs[12].analog1Value);
}

bool voltageRegulator::chkMeterMsg(char *cbuf, char clen)
{
    char txc;
    
    //Ensure Analog channl count is correct
    if (vRegData.numAnalog!=cbuf[6])
    {
        #ifdef netmsgdebug
        printf("\r\nFast Meter Analog Channel Count Off\r\n");
        #endif
        return false;
    }
    //Ensure Digital register count is correct
    if (vRegData.numDigital!=cbuf[8])
    {
        #ifdef netmsgdebug
        printf("\r\nFast Meter Digital Channel Count Off\r\n");
        #endif
        return false;
    }
    char anum=16;
    char nxc;
    //Verify Analog names are correct
    for (txc=0;txc<vRegData.numAnalog;txc++)
    {
        for (nxc=0;nxc<6;nxc++)
        {
            if(vRegData.analogs[txc].analogName[nxc]!=cbuf[anum+nxc])
            {
                #ifdef netmsgdebug
                printf("\r\nPoint %d Failed\r\n",txc);
                #endif
                return false;
            }
        }
        anum = anum + 11;
    }
    return true;
}

bool voltageRegulator::chkDemMeterMsg(char *cbuf, char clen)
{
    char txc;
    
    if (vRegData.numDemAnalog!=cbuf[6])
    {
        #ifdef netmsgdebug
        printf("\r\nDemand Analog Channel Count Off\r\n");
        #endif
        return false;
    }
    char anum=18;
    char nxc;
    //Verify Analog names are correct
    for (txc=0;txc<vRegData.numDemAnalog;txc++)
    {
        for (nxc=0;nxc<6;nxc++)
        {
            if(vRegData.analogs[txc+vRegData.numAnalog].analogName[nxc]!=cbuf[anum+nxc])
            {
                #ifdef netmsgdebug
                printf("\r\nPoint %d Failed\r\n",txc);
                #endif
                return false;
            }
        }
        anum = anum + 11;
    }
    return true;
}

void voltageRegulator::setDemMeterData(char *cbuf, char pos, char clen)
{
    float4byte valpack;
    short2byte timepack;
    char txc;
    char anum=pos+4;
    
    char chksum=0;
    if (clen>vRegData.fmMsgLen[4])
    {
        for (txc=0;txc<vRegData.fmMsgLen[4];txc++)
        {
            chksum=chksum+cbuf[txc];
        }
        if (chksum==cbuf[vRegData.fmMsgLen[4]])
        {
            printf("Chksum: %02x\r\n",chksum);
        }
        else
        {
            printf("Chksum Error: %02x, Message: %02x\r\n",chksum,cbuf[vRegData.fmMsgLen[4]]);
            return;
        }
    }
    else
    {
        printf("Message Length Wrong: %d Bytes\r\n",clen);
        return;
    }
    
    for (txc=0;txc<vRegData.numDemAnalog;txc++)
    {
        valpack.bytes[3]=cbuf[anum];
        valpack.bytes[2]=cbuf[anum+1];
        valpack.bytes[1]=cbuf[anum+2];
        valpack.bytes[0]=cbuf[anum+3];
        vRegData.analogs[txc].analog1Value = valpack.cmdflt;
        anum = anum + 4;
    }
    vRegData.demTimeStamp.month=cbuf[anum];
    vRegData.demTimeStamp.day=cbuf[anum+1];
    vRegData.demTimeStamp.year=cbuf[anum+2];
    vRegData.demTimeStamp.hour=cbuf[anum+3];
    vRegData.demTimeStamp.min=cbuf[anum+4];
    vRegData.demTimeStamp.sec=cbuf[anum+5];
    timepack.bytes[1]=cbuf[anum+6];
    timepack.bytes[0]=cbuf[anum+7];
    vRegData.demTimeStamp.msec=timepack.cmdshort;
}

char voltageRegulator::getMeterReport(char *dataStr)
{
    char scx;
    char buflen;
    vRegData.calculated[0].analog1Value=voltageMinMax.getMin();
    vRegData.calculated[1].analog1Value=voltageAvg.getAvg();
    vRegData.calculated[2].analog1Value=voltageMinMax.getMax();
    vRegData.calculated[3].analog1Value=currentMinMax.getMin();
    vRegData.calculated[4].analog1Value=currentAvg.getAvg();
    vRegData.calculated[5].analog1Value=currentMinMax.getMax();
    vRegData.calculated[6].analog1Value=powerMinMax.getMin();
    vRegData.calculated[7].analog1Value=powerAvg.getAvg();
    vRegData.calculated[8].analog1Value=powerMinMax.getMax();
    vRegData.calculated[9].analog1Value=reactiveMinMax.getMin();
    vRegData.calculated[10].analog1Value=reactiveAvg.getAvg();
    vRegData.calculated[11].analog1Value=reactiveMinMax.getMax();
    vRegData.calculated[12].analog1Value=tapMinMax.getMin();
    vRegData.calculated[13].analog1Value=tapMinMax.getMax();
    buflen = sprintf(dataStr,
    "%2d:%2d ,%7.2f,%7.2f,%7.2f,%7.2f,%7.2f,%7.2f,%7d,%7d,%7d,%7d,%7d,%7d,%7d,%7d,%2d,%2d,%2d,%2d,%2d,%2d,%2d,%2d,%1d%1d%1d\r\n",
    vRegData.timeStamp.hour,vRegData.timeStamp.min,
    vRegData.calculated[0].analog1Value,vRegData.calculated[1].analog1Value,vRegData.calculated[2].analog1Value,
    vRegData.calculated[3].analog1Value,vRegData.calculated[4].analog1Value,vRegData.calculated[5].analog1Value,
    (int)vRegData.calculated[6].analog1Value,(int)vRegData.calculated[7].analog1Value,(int)vRegData.calculated[8].analog1Value,
    (int)vRegData.calculated[9].analog1Value,(int)vRegData.calculated[10].analog1Value,(int)vRegData.calculated[11].analog1Value,
    (int)vRegData.calculated[12].analog1Value,(int)vRegData.calculated[13].analog1Value,
    vRegData.statCounters[0],vRegData.statCounters[1],vRegData.statCounters[2],vRegData.statCounters[3],
    vRegData.statCounters[4],vRegData.statCounters[5],vRegData.statCounters[6],vRegData.statCounters[7],
    vRegData.stats[0],vRegData.stats[1],vRegData.stats[2]);
    
    voltageAvg.resetNum();
    voltageMinMax.resetNum();
    currentAvg.resetNum();
    currentMinMax.resetNum();
    powerAvg.resetNum();
    powerMinMax.resetNum();
    reactiveAvg.resetNum();
    reactiveMinMax.resetNum();
    tapMinMax.resetNum();
    
    for (scx=0;scx<8;scx++)
    {
        vRegData.statCounters[scx]=0;
    }
    for (scx=0;scx<3;scx++)
    {
        vRegData.stats[scx]=false;
    }
    return buflen;
}

char * voltageRegulator::getTargets(void)
{
    return vRegData.digitalTargets;
}