#include "netStatusReg.h"

//static volatile unsigned int statusReg = 0;

netDevStatus::netDevStatus(unsigned int setStatus,unsigned int settxMC,unsigned int setrxMC,unsigned int setfmTC,unsigned int setsTC,char conFailLim)
{
    statusReg = setStatus;
    txMessageCount=settxMC;
    rxMessageCount=setrxMC;
    fmTimeoutCount=setfmTC;
    serTimeoutCount=setsTC;
    connectFailLimit=conFailLim;
    connectSuccessCount=0;
    connectFailCount=0;
}

void netDevStatus::iedOnline(bool connectSuccess)
{
    if (connectSuccess)
    {
        connectSuccessCount++;
        connectFailCount=0;
    }
    else
    {
        connectFailCount++;
        connectSuccessCount=0;
        msgFailCount++;
        if (connectFailCount>connectFailLimit)
        {
            statusReg &= ~devOnline;
            statusReg &= ~fmEnabled;
            statusReg &= ~fmdEnabled;
        }
    }
}

unsigned int netDevStatus::getStatus(void)
{
    return statusReg;
}

//Get count Value
unsigned int netDevStatus::getCount(char counterNum)
{
    switch (counterNum)
    {
        case 1:
            return txMessageCount;
        case 2:
            return rxMessageCount;
        case 3:
            return fmTimeoutCount;
        case 4:
            return serTimeoutCount;
        case 5:
            return msgFailCount;
        default:
            return 0;
    }
}

//Increment count Value
void netDevStatus::incCount(char counterNum)
{
    switch (counterNum)
    {
        case 1:
            txMessageCount++;
            break;
        case 2:
            rxMessageCount++;
            break;
        case 3:
            fmTimeoutCount++;
            break;
        case 4:
            serTimeoutCount++;
            break;
        default:
            break;
    }
}

//Set count Value
void netDevStatus::setCount(char counterNum, unsigned int newCount)
{
    switch (counterNum)
    {
        case 1:
            txMessageCount=newCount;
            break;
        case 2:
            rxMessageCount=newCount;
            break;
        case 3:
            fmTimeoutCount=newCount;
            break;
        case 4:
            serTimeoutCount=newCount;
            break;
        default:
            break;
    }
}

void netDevStatus::setDevMsgReq(char setReq)
{
    devMsgReq=setReq;
}
char netDevStatus::getDevMsgReq(void)
{
    return devMsgReq;
}
void netDevStatus::setDevMsgPos(char setPos)
{
    devMsgPos=setPos;
}
char netDevStatus::getDevMsgPos(void)
{
    return devMsgPos;
}
//Return true if bit is set
bool netDevStatus::bit_isset(unsigned int m)
{
    return (((statusReg) & (m)) ? true : false);
}

//Return true if bit is clear
bool netDevStatus::bit_isclear(unsigned int m)
{
    return  (((statusReg) & (m)) ? false : true);
}

//Set bit
void netDevStatus::bit_toset(unsigned int m)
{
    ((statusReg) |= (m));
}

//Clear bit
void netDevStatus::bit_toclear(unsigned int m)
{
    ((statusReg) &= ~(m));
}
//Bit set if set, do nothing if not set
void netDevStatus::bit_sis(unsigned int c,unsigned int m)
{
    (((statusReg) & (c)) ? ((statusReg) |= (m)) : (statusReg = statusReg));
}
//Bit clear if set, do nothing if not set
void netDevStatus::bit_cis(unsigned int c,unsigned int m)
{
    (((statusReg) & (c)) ? ((statusReg) &= ~(m)) : (statusReg = statusReg));
}
//Bit set if set, clear if not set
void netDevStatus::bit_sisc(unsigned int c,unsigned int m)
{
    (((statusReg) & (c)) ? ((statusReg) |= (m)) : ((statusReg) &= ~(m)));
}
//Bit clear if set, set if not set
void netDevStatus::bit_ciss(unsigned int c,unsigned int m)
{
    (((statusReg) & (c)) ? ((statusReg) &= ~(m)) : ((statusReg) |= (m)));
}

//Bit set if clear, do nothing if set
void netDevStatus::bit_sic(unsigned int c,unsigned int m)
{
    (((statusReg) & (c)) ? (statusReg = statusReg) : ((statusReg) |= (m)));
}
//Bit clear if clear, do nothing if set
void netDevStatus::bit_cic(unsigned int c,unsigned int m)
{
    (((statusReg) & (c)) ? (statusReg = statusReg) : ((statusReg) &= ~(m)));
}
//Bit set if clear, clear if set
void netDevStatus::bit_sicc(unsigned int c,unsigned int m)
{
    (((statusReg) & (c)) ? ((statusReg) &= ~(m)) : ((statusReg) |= (m)));
}
//Bit clear if clear, set if set
void netDevStatus::bit_cics(unsigned int c,unsigned int m)
{
    (((statusReg) & (c)) ? ((statusReg) |= (m)) : ((statusReg) &= ~(m)));
}