#ifndef MKNETATATREG_H
#define MKNETATATREG_H

#define pollEnabled         0x80000000
#define fmEnabled           0x40000000
#define fmdEnabled          0x20000000
#define serEnabled          0x10000000
#define recEnabled          0x08000000
//#define reserved            0x04000000
#define cltIsActive         0x02000000
#define cltCloseConnection  0x01000000
//#define reserved            0x00800000
#define fmOnline            0x00400000
#define fmdOnline           0x00200000
#define sendRetry           0x00100000
#define serTimeout          0x00080000
#define fmTimeout           0x00040000
//#define reserved            0x00020000
#define serMsgRx            0x00010000
#define serPollReq          0x00008000
#define fmPollReq           0x00004000
#define fmdPollReq          0x00002000
#define fmCfgReq            0x00001000
#define serPollInProg       0x00000800
#define fmPollInProg        0x00000400
#define fmdPollInProg       0x00000200
#define fmCfgInProg         0x00000100
#define serRespRx           0x00000080
#define fmRespRx            0x00000040
#define fmdRespRx           0x00000020
#define recDataFile         0x00000010
#define serCloseConnection  0x00000008
#define fmCloseConnection   0x00000004
#define fmdCloseConnection  0x00000002
#define devOnline           0x00000001

#define cltclose            0x031F0FEE
#define serclose            0x03100888
#define fmclose             0x03100766

class netDevStatus
{
        unsigned int statusReg;
    
        unsigned int txMessageCount;    //1
        unsigned int rxMessageCount;    //2
        unsigned int fmTimeoutCount;    //3
        unsigned int serTimeoutCount;   //4
        unsigned int msgFailCount;      //5
        
        char connectFailCount;
        char connectSuccessCount;
        char connectFailLimit;
        
        char devMsgReq;
        char devMsgPos;
    
    public:
        
        netDevStatus(unsigned int,unsigned int,unsigned int,unsigned int,unsigned int,char);
        
        void iedOnline(bool);
    
        unsigned int getStatus(void);
        
        //Get count Value
        unsigned int getCount(char);
        
        //Increment count Value
        void incCount(char);
        
        //Set count Value
        void setCount(char, unsigned int);
        
        void setDevMsgReq(char);
        
        char getDevMsgReq(void);
                
        void setDevMsgPos(char);
        
        char getDevMsgPos(void);
                
        //Return true if bit is set
        bool bit_isset(unsigned int);
        //Return true if bit is clear
        bool bit_isclear(unsigned int);
        //Set bit
        void bit_toset(unsigned int);
        //Clear bit
        void bit_toclear(unsigned int);
        
        //Bit set if set, do nothing if not set
        void bit_sis(unsigned int,unsigned int);
        //Bit clear if set, do nothing if not set
        void bit_cis(unsigned int,unsigned int);
        //Bit set if set, clear if not set
        void bit_sisc(unsigned int,unsigned int);
        //Bit clear if set, set if not set
        void bit_ciss(unsigned int,unsigned int);
        
        //Bit set if clear, do nothing if set
        void bit_sic(unsigned int,unsigned int);
        //Bit clear if clear, do nothing if set
        void bit_cic(unsigned int,unsigned int);
        //Bit set if clear, clear if set
        void bit_sicc(unsigned int,unsigned int);
        //Bit clear if clear, set if set
        void bit_cics(unsigned int,unsigned int);
};
#endif