#include "analogMinMax.h"

analogMinMax::analogMinMax(float nominalVal, bool useMinLimit, bool minIsPercent, float minSetVal, bool useMaxLimit, bool maxIsPercent, float maxSetVal)
{
    nomVal = nominalVal;
    maxLim=useMinLimit;
    minLim=useMaxLimit;
    if (minIsPercent)
    {
        minLimVal = nominalVal*minSetVal;
    }
    else
    {
        minLimVal = minSetVal;
    }
    if (maxIsPercent)
    {
        maxLimVal = nominalVal*maxSetVal;
    }
    else
    {
        maxLimVal = maxSetVal;
    }
}

void analogMinMax::putVal(float newval)
{
    if (maxLim)
    {
        if (newval>maxLimVal)
        {
            return;
        }
    }
    if (minLim)
    {
        if (newval<minLimVal)
        {
            return;
        }
    }
    if (maxSet==false)
    {
        maxVal=newval;
        maxSet=true;
    }
    else
    {
        if (newval>maxVal)
        {
            maxVal=newval;
        }
    }
    if (minSet==false)
    {
        minVal=newval;
        minSet=true;
    }
    else
    {
        if (newval<minVal)
        {
            minVal=newval;
        }
    }
}

float analogMinMax::getMin(void)
{
    return minVal;
}

float analogMinMax::getMax(void)
{
    return maxVal;
}

void analogMinMax::resetNum(void)
{
    maxVal=0;
    minVal=0;
    minSet=false;
    maxSet=false;
}

