#include "analogAverager.h"

analogAverager::analogAverager(float nominalVal, bool useMinLimit, bool minIsPercent, float minSetVal, bool useMaxLimit, bool maxIsPercent, float maxSetVal)
{
    nomVal = nominalVal;
    maxLim=useMinLimit;
    minLim=useMaxLimit;
    if (minIsPercent)
    {
        minVal = nominalVal*minSetVal;
    }
    else
    {
        minVal = minSetVal;
    }
    if (maxIsPercent)
    {
        maxVal = nominalVal*maxSetVal;
    }
    else
    {
        maxVal = maxSetVal;
    }
    sampleNum=0;
}

void analogAverager::putVal(float newval)
{
    if (maxLim)
    {
        if (newval>maxVal)
        {
            return;
        }
    }
    if (minLim)
    {
        if (newval<minVal)
        {
            return;
        }
    }
    
    if (sampleNum>=10)
    {
        averageVals[1]=newval;
        averageVals[0]=((averageVals[0]+averageVals[1])*0.5f);
    }
    else
    {
        sampleVals[sampleNum]=newval;
        sampleNum++;
    }
    if (sampleNum==10)
    {
        averageVals[0]=(sampleVals[0]+sampleVals[1]+sampleVals[2]+sampleVals[3]+sampleVals[4]+sampleVals[5]+sampleVals[6]+sampleVals[7]+sampleVals[8]+sampleVals[9])*0.1f;
        sampleNum++;
    }
}

float analogAverager::getAvg(void)
{
    return averageVals[0];
}

void analogAverager::resetNum(void)
{
    sampleNum=0;
    averageVals[0]=0;
    averageVals[1]=0;
}

