#include "select-demo.h"

#if DEMO == DEMO_HTTP

#include "mbed.h"
#include "http_request.h"
#include "network-helper.h"
#include "mbed_mem_trace.h"
#include "HTS221Sensor.h"

static DevI2C devI2c(PB_11,PB_10);
static HTS221Sensor hum_temp(&devI2c);

char* thingspark_URL = "http://api.thingspark.kr";
char* thingspark_APIkey = "CHANGE API KEY";
char urlBuffer[256];

void dump_response(HttpResponse* res) {
    printf("Status: %d - %s\n", res->get_status_code(), res->get_status_message().c_str());

    printf("Headers:\n");
    for (size_t ix = 0; ix < res->get_headers_length(); ix++) {
        printf("\t%s: %s\n", res->get_headers_fields()[ix]->c_str(), res->get_headers_values()[ix]->c_str());
    }
    printf("\nBody (%d bytes):\n\n%s\n", res->get_body_length(), res->get_body_as_string().c_str());
}


int main() {
    unsigned int updateCnt=0;
    float hum_val=12, temp_val=34;
    
    printf("DISCO-L457VG-IOT01A WiFi + thingspark example\r\n");

#ifdef MBED_MAJOR_VERSION
    printf("Mbed OS version %d.%d.%d\n\n", MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);
#endif

    printf("<< =========== Network check.. =========== >>\r\n");

    // Connect to the network with the default networking interface
    // if you use WiFi: see mbed_app.json for the credentials
    NetworkInterface* network = connect_to_default_network_interface();
    if (!network) {
        printf("Cannot connect to the network, see serial output\n");
        return 1;
    }

    printf("Successfully access to network\n\n");

    printf("MAC: %s\n", network->get_mac_address());
    printf("IP: %s\n", network->get_ip_address());
    printf("Netmask: %s\n", network->get_netmask());
    printf("Gateway: %s\n", network->get_gateway());

    printf("<< =========== Sensor check.. =========== >>\r\n");
    
    hum_temp.init(NULL);
    hum_temp.enable();

    // Do a GET request to thingspark.kr
    while(1){
        // By default the body is automatically parsed and stored in a buffer, this is memory heavy.
        // To receive chunked response, pass in a callback as last parameter to the constructor.

        hum_temp.get_humidity(&hum_val);
        hum_temp.get_temperature(&temp_val);
        printf("HT221 hum: %.1f %, temp: %.1f C\n", hum_val, temp_val);
        sprintf(urlBuffer, "%s/update?apiKey=%s&field1=%.1f&field2=%.1f", thingspark_URL, thingspark_APIkey, hum_val, temp_val);

        printf("[DEBUG] %s\n", urlBuffer);
        HttpRequest* get_req = new HttpRequest(network, HTTP_GET, urlBuffer);
        
        HttpResponse* get_res = get_req->send();
        if (!get_res) {
            printf("HttpRequest failed (error code %d)\n", get_req->get_error());
            return 1;
        }

        printf("\n----- HTTP GET response -----\n");
        dump_response(get_res);

        delete get_req;
        printf("\nUpdate count %d (Every 30sec, data update to thingspark server)\n",updateCnt++);
        wait(30);
    }

    wait(osWaitForever);
}

#endif
