#include "mbed.h"
#include "mlx90614.h"
 
DigitalOut myled(LED1); //displays I2C wait
I2C i2c(PB_9, PB_8);   //sda,scl
Serial pc(USBTX, USBRX);  //serial usb config
 
MLX90614 IR_thermometer(&i2c, 0x5A);
//setup an MLX90614 using MLX90614 library from
// http://mbed.org/users/aquahika/libraries/MLX90614/lsixz6
 
float temp; //temperature in degrees C
 
int main() {
    pc.printf("START\r\n");
    while (1) {
        myled=1; // if led1 on - waiting on I2C
        if (IR_thermometer.getTemp(&temp)) {
            //gets temperature from sensor via I2C bus
            myled=0;
            //print temperature on PC
            pc.printf("Temperature is %.2f degrees C\r\n",temp);
        }
        //wait for device to produce next temperature reading
        wait(2);
    }
}