#ifndef PHYSCOM_RPCFUNCTION_H
#define PHYSCOM_RPCFUNCTION_H

#include "rpc.h"

namespace physcom {

/**
 *
 * Class to call custom functions over RPC
 * For details see rpc.h
 *
 */
class RPCFunction: public RPC {
public:
    /**
     * Constructor
     *
     * @param f Pointer to the function to call. the function must be of the form void foo(char * input, char * output)
     * @param name The name of this object
     */
    RPCFunction(void (*f)(char*, char*), const char* = NULL);

    /*
     * Calls the attached function passing the string in but doesn't return the result.
     *  @param input: The string to be passed into the attached function. 
     * This string can consist of any ASCII characters apart from escape codes. 
     * The usual limtations on argument content for RPC strings has been removed
     * @param output: string output from the function
     */
    virtual void run(char *input, char *output);


private:
    void (*function_ptr)(char*, char*);
};

} // Namespace physcom

#endif
