#include "mbed.h"
#include "m3pi.h"

namespace physcom {
    
M3pi::M3pi(PinName nrst, PinName tx, PinName rx) :  Stream("m3pi"), _nrst(nrst), _ser(tx, rx)  {
    _ser.baud(115200);
    reset();
    m1_speed = 0;
    m2_speed = 0;
}

M3pi::M3pi() :  Stream("m3pi"), _nrst(p23), _ser(p9, p10)  {
    _ser.baud(115200);
    reset();
    m1_speed = 0;
    m2_speed = 0;
}


void M3pi::reset () {
    _nrst = 0;
    wait (0.01);
    _nrst = 1;
    wait (0.1);
    m1_speed = 0;
    m2_speed = 0;
}

void M3pi::stop(){
    while(m1_speed > 0 || m2_speed > 0){
        if((m1_speed - 0.05) >= 0){
            m1_speed -= 0.05;
        }else{
            m1_speed = 0;
        }
        if((m2_speed - 0.05) >= 0){
            m2_speed -= 0.05;
        }else{
            m2_speed = 0;
        }
        
        activate_motor(0, m1_speed);
        activate_motor(1, m2_speed);  
        wait_ms(35);
    }   
}  

void M3pi::activate_motor (int motor, float speed) {
    char opcode = 0x0;
    if (speed > 0.0) {
        if (motor==0){
            opcode = M1_FORWARD;
            m1_speed = speed;
        }
        else {
            opcode = M2_FORWARD;
            m2_speed = speed;
        }
    } else {
        if (motor==0) {
            opcode = M1_BACKWARD;
            m1_speed = speed;
        }
        else {
            opcode = M2_BACKWARD;
            m2_speed = speed;
        }
    }
    unsigned char arg = 0x7f * abs(speed);

    _ser.putc(opcode);
    _ser.putc(arg);
}

float M3pi::battery() {
    _ser.putc(SEND_BATTERY_MILLIVOLTS);
    char lowbyte = _ser.getc();
    char hibyte  = _ser.getc();
    float v = ((lowbyte + (hibyte << 8))/1000.0);
    return(v);
}

void M3pi::raw_sensors( int sensors[5]) {
    int sensor1 = 0;
    int sensor2 = 0;
    int sensor3 = 0;
    int sensor4 = 0;
    int sensor5 = 0;
    _ser.putc(SEND_RAW_SENSOR_VALUES);
    sensor1 = _ser.getc();
    sensor1 += _ser.getc() << 8;
    sensor2 = _ser.getc();
    sensor2 += _ser.getc() << 8;
    sensor3 = _ser.getc();
    sensor3 += _ser.getc() << 8;
    sensor4 = _ser.getc();
    sensor4 += _ser.getc() << 8;
    sensor5 = _ser.getc();
    sensor5 += _ser.getc() << 8;
    
    sensors[0] = sensor1;
    sensors[1] = sensor2;
    sensors[2] = sensor3;
    sensors[3] = sensor4;
    sensors[4] = sensor5;
}

void M3pi::calibrated_sensors( int sensors[5]) {
    int sensor1 = 0;
    int sensor2 = 0;
    int sensor3 = 0;
    int sensor4 = 0;
    int sensor5 = 0;
    _ser.putc(SEND_CALIBRATED_SENSOR_VALUES);
    sensor1 = _ser.getc();
    sensor1 += _ser.getc() << 8;
    sensor2 = _ser.getc();
    sensor2 += _ser.getc() << 8;
    sensor3 = _ser.getc();
    sensor3 += _ser.getc() << 8;
    sensor4 = _ser.getc();
    sensor4 += _ser.getc() << 8;
    sensor5 = _ser.getc();
    sensor5 += _ser.getc() << 8;
    
    sensors[0] = sensor1;
    sensors[1] = sensor2;
    sensors[2] = sensor3;
    sensors[3] = sensor4;
    sensors[4] = sensor5;
}

char M3pi::sensor_auto_calibrate() {
    _ser.putc(AUTO_CALIBRATE);
    return(_ser.getc());
}

int M3pi::_putc (int c) {
    _ser.putc(DO_PRINT);  
    _ser.putc(0x1);       
    _ser.putc(c);         
    wait (0.001);
    return(c);
}

int M3pi::_getc (void) {
    char r = 0;
    return(r);
}

} // Namespace physcom