#include "rpc.h"

using namespace std;

namespace physcom {

RPC::RPC(const char *name) {
    if (name != NULL) {
        _name = new char[strlen(name) + 1];
        strcpy(_name, name);
    } else {
        _name = new char[12];
        sprintf(_name, "obj%p", this);
    }
    // put this object at head of the list
    _next = _head;
    _head = this;
}

RPC::~RPC() {
    // remove this object from the list
    if (_head == this) { // first in the list, so just drop me
        _head = _next;
    } else {            // find the object before me, then drop me
        RPC* p = _head;
        while (p->_next != this) {
            p = p->_next;
        }
        p->_next = _next;
    }
}

RPC *RPC::lookup(const char *name) {
    size_t len = strlen(name);
    for (RPC *p = _head; p != NULL; p = p->_next) {
        /* Check that p->_name matches name and is the correct length */
        if (strncmp(p->_name, name, len) == 0 && (strlen(p->_name) == len)) {
            return p;
        }
    }
    return NULL;
}

RPC *RPC::_head = NULL;

bool RPC::call(char *input, char *output) {
    // A request has the syntax: "/Object/Method arg1 arg2 ... "
    const char* ARGUMENT_DELIMITER = " ";
    const char* REQUEST_DELIMITER = "/";
    
    if (input == NULL) {
        sprintf(output, "ERROR: Invalid Request");
        return false;
    }
    char *request = strtok (input, ARGUMENT_DELIMITER);
    char *arguments = strtok(NULL, "");
    char *object = strtok (request, REQUEST_DELIMITER);
    char *method = strtok (NULL, "");
         
    if (object == NULL) {
        sprintf(output, "ERROR: Invalid Oject");
        return false;
    }

    if (method == NULL) {
        sprintf(output, "ERROR: Invalid Method");
        return false;
    }
    
    /* First try matching an instance */
    RPC *p = lookup(object);
    
    if (p != NULL) {
        if (strcmp(method, "run") != 0) {
            sprintf(output, "ERROR: Could not find method %s. Try executing method 'run'", 
                method);
            return false;    
        }
    } else {
        sprintf(output, "ERROR: Could not find object %s.", object);
        return false;    
    }  

    p->run(arguments, output);
    return true;
}


void RPC::run(char *input, char *output) {
        sprintf(output, "ERROR: Unimplemented");
}

} // namespace physcom
