

#include "mbed.h"
#include<string>
#include "Android.h"
#include "rtos.h"

#define ARDUINO_STARTED "AR1"
#define ANDROID_CONNECTED "AN1"
#define OK "OK"
#define ARDUINO_HEART_BEAT "ARD_HB"
#define ANDROID_HEART_BEAT "AND_HB"
#define DISPENSING_STARTED "DISP1"
#define DISPENSING_COMPLETE "DISP2"
#define DISPENSING_NO_PAYMENT "DISP0"
#define PRODUCT_TAKEN "TAKEN"
#define DISPENSING_FAILED "DISP3"
#define TAKE_PAYMENT "PAY1"
#define TAKING_PAYMENT "PAY2"
#define PAYMENT_RECEIVED "PAY3"
#define PAYMENT_FAILED "PAY4"
#define SHOW_HOME_SCREEN "HOME"
#define PRODUCT_SELECTED "SELECTION"

#define COMMAND_CONNECTED 100
#define COMMAND_HEARTH_BEAT 101
#define COMMAND_PRODUCT_SELECT 102
#define COMMAND_TAKE_PAYMENT 103
#define COMMAND_DISPENSE 104
#define COMMAND_VALUE 200
#define COMMAND_UNKNOWN 900




Android::Android(Serial& serial, Carousel& carousel): serial(serial), myled(LED1), carousel(carousel) {
    this->serial.attach(callback(this, &Android::onData));
    this->ticker.attach(callback(this, &Android::hearthBeat), 5.0f);

}


void Android::hearthBeat(void)
{
    this->sendToAndroid(ARDUINO_HEART_BEAT);
}

void Android::sendToAndroid(string message)
{
    printf("Sent to Android: %s\n", message);
    this->serial.printf("%s\n", message);
    this->serial.putc(-91);    
}


void Android::onData(void)
{
    char command[50];

    this->serial.scanf("%s", command);
    
    if (strncmp(command, ANDROID_CONNECTED, sizeof(ANDROID_CONNECTED)-1) == 0) {
        printf("%s\n", command);
        this->sendToAndroid(OK);
    } else if (strncmp(command, ANDROID_HEART_BEAT, sizeof(ANDROID_HEART_BEAT)-1) == 0) {
        printf("%s\n", command);
    } else if (strncmp(command, PRODUCT_SELECTED, sizeof(PRODUCT_SELECTED)-1) == 0) {
        int section = this->readNumber();
        printf("Selected %d\n", section);
    } else if (strncmp(command, TAKE_PAYMENT, sizeof(TAKE_PAYMENT)-1) == 0) {
        printf("%s\n", command);
    } else if (strncmp(command, DISPENSING_NO_PAYMENT, sizeof(DISPENSING_NO_PAYMENT)-1) == 0) {
        int section = this->readNumber();
        printf("Dispensing %d\n", section);
        this->carousel.dispenseProduct(section);
    } else {
        printf("Unknown command: |%s|\n", command);
    }        
       
    if (this->serial.readable()){
        this->serial.getc();//read newline
    } 
}


int Android::readNumber() {
    this->serial.getc();//read newline
    char serialString[5];
    this->serial.scanf("%s", serialString);
    
    int answer;
    char* end = NULL;
    answer = strtol (serialString,&end,10);   
    return answer; 
}
