#include "USBHostConf.h"
#include "USBHost.h"
#include "BaseUvc.h"
#include "decodeMJPEG.h"

// Logitech C270
#define C270_VID 0x046d
// #define C270_PID 0x0825 
#define C270_PID 0x0819 // for C210
#define C270_160x120 2
#define C270_176x144 3
#define C270_320x176 4
#define C270_320x240 5
#define C270_352x288 6
#define C270_432x240 7
#define C270_640x480 1
#define C270_544x288 8
#define C270_640x360 9
#define C270_752x416 10
#define C270_800x448 11
#define C270_800x600 12

#define C270_MJPEG 2
#define C270_YUV2  1

#define C270_EN  0x81
#define C270_MPS  192
#define C270_IF_ALT 1

#define TEST_ASSERT(A) while(!(A)){fprintf(stderr,"\n\n%s@%d %s ASSERT!\n\n",__PRETTY_FUNCTION__,__LINE__,#A);exit(1);};

class IsochronousEp;
class BaseUvc;
/** 
 * A class to communicate a C270
 */
class USBHostC270 : public IUSBEnumerator, public BaseUvc, public decodeMJPEG {
public:
    /**
    * Constructor
    *
    */
    USBHostC270(int formatIndex = C270_MJPEG, int frameIndex = C270_160x120, uint32_t interval = _5FPS);

    /**
    * Check if a C270 device is connected
    *
    * @return true if a MSD device is connected
    */
    bool connected();

    /**
     * Try to connect to a C270 device
     *
     * @return true if connection was successful
     */
    bool connect();

    /**
     * read jpeg image
     *
     * @param buf read buffer 
     * @param size buffer size 
     * @param timeout_ms timeout default 15sec
     * @return jpeg size if read success else -1
     */
    int readJPEG(uint8_t* buf, int size, int timeout_ms = 15*1000);

protected:
    //From IUSBEnumerator
    virtual void setVidPid(uint16_t vid, uint16_t pid);
    virtual bool parseInterface(uint8_t intf_nb, uint8_t intf_class, uint8_t intf_subclass, uint8_t intf_protocol); //Must return true if the interface should be parsed
    virtual bool useEndpoint(uint8_t intf_nb, ENDPOINT_TYPE type, ENDPOINT_DIRECTION dir); //Must return true if the endpoint will be used

private:
    bool dev_connected;

    int c270_intf;
    bool c270_device_found;
    bool c270_vid_pid_found;
    int _formatIndex;
    int _frameIndex;
    uint32_t _interval;
    uint8_t _seq;
    uint8_t* _buf;
    int _pos;
    int _size;

    virtual void outputJPEG(uint8_t c, int status); // from decodeMJPEG
    void callback_motion_jpeg(uint16_t frame, uint8_t* buf, int len);
    void init();
    void onDisconnect();
};
