#define MSDFILESYSTEM 0 // 0:SDFileSystem, 1:USBHostMSD

#if MSDFILESYSTEM
#include "USBHostMSD.h"
#else
#include "SDFileSystem.h"
#endif
#include "USBHostC270.h"

Serial pc(USBTX, USBRX);
BusOut leds(LED1, LED2, LED3);
#if !MSDFILESYSTEM
SDFileSystem  sd(p5, p6, p7, p8,  "sd");
#endif

#include "TextLCD.h"
TextLCD     lcd( p24, p26, p27, p28, p29, p30 ); // rs, e, d0-d3

int main() {
    pc.baud(921600);
#if MSDFILESYSTEM
    USBHostMSD* msd = new USBHostMSD("usb"); // USB flash drive
#endif
    USBHostC270* cam = new USBHostC270(C270_MJPEG, C270_160x120, _5FPS); // Logitech C270
    while(!cam->connect()) {
        Thread::wait(500);
    }

    uint8_t buf[1024*3];
    Timer interval_t;
    interval_t.reset();
    interval_t.start();
    int shot = 0;
    while(1) {
        if (interval_t.read_ms() > 2000) {
            printf("start\r\n");
            int r = cam->readJPEG(buf, sizeof(buf));
            char path[32];
#if MSDFILESYSTEM
            snprintf(path, sizeof(path), "/usb/image%02d.jpg", shot % 20);
#else
            snprintf(path, sizeof(path), "/sd/image%02d.jpg", shot % 20);
#endif
            lcd.locate( 0, 0 );
            lcd.printf( path );
            printf("%d %s %d bytes\r\n", shot, path, r);
#if MSDFILESYSTEM
            if (msd->connected()) 
#endif
            {
                FILE* fp = fopen(path, "wb");
                if (fp) {
                    lcd.locate( 0, 1 );
                    lcd.printf( "writing." );
                    printf("write\r\n");
                    fwrite(buf, r, 1, fp);
                    fclose(fp);
                    lcd.locate( 0, 1 );
                    lcd.printf( "finish. " );
                }
                shot++;
                leds = shot % 8;
            }
            interval_t.reset();
            printf("end\r\n");
        }
#if MSDFILESYSTEM
        if (!msd->connected()) msd->connect();
#endif
        cam->poll();    
    }
}
