#include "mbed.h"
#include "aqm1248a_lcd.h"
#include "GT20L16J1Y_font.h"
#include "utf8_table.h"
 
#include <stdlib.h>

aqm1248a_lcd lcd;

const static 
char mbedlogo128x48[768]
= {
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc7,0x83,0xe0,0x3c,0x7c,0x00,0x7e,0x00,0x3e,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xdf,0xef,0xf8,0x3d,0xfe,0x01,0xff,0x80,0x7f,0xbc,0x00,0x00,0x00,
   0x00,0x00,0x03,0xff,0xff,0xf8,0x3f,0xff,0x03,0xff,0xc0,0xff,0xfc,0x00,0x00,0x00,
   0x00,0x00,0x03,0xf1,0xfc,0x7c,0x3f,0x0f,0x87,0xc3,0xe1,0xf0,0xfc,0x00,0x00,0x00,
   0x00,0x00,0x03,0xe0,0xf8,0x3c,0x3e,0x07,0x87,0x81,0xe1,0xe0,0x7c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0x03,0xcf,0x00,0xe3,0xc0,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0x03,0xcf,0x00,0xf3,0xc0,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0x03,0xcf,0xff,0xf3,0xc0,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0x03,0xcf,0xff,0xf3,0xc0,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0x03,0xcf,0xff,0xf3,0xc0,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0x03,0xcf,0x00,0x03,0xc0,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3e,0x03,0xcf,0x00,0x03,0xc0,0x7c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3e,0x07,0x87,0x80,0x01,0xe0,0x7c,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3f,0x0f,0x87,0xc1,0xc1,0xf0,0xfc,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3f,0xff,0x03,0xff,0xf0,0xff,0xfc,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3d,0xfe,0x01,0xff,0xe0,0x7f,0xbc,0x00,0x00,0x00,
   0x00,0x00,0x03,0xc0,0xf0,0x3c,0x3c,0xfc,0x00,0x7f,0x00,0x3f,0x3c,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};


const static struct Bitmap logo = {
  128,
  48,
  16,
  (char*)mbedlogo128x48,
};

const char target[] = 
#if defined(TARGET_NUCLEO_L152RE)
"STM32 Nucleo L152RE"
#elif defined(TARGET_KL05Z)
"Freescale FRDM-KL05Z"
#else
"????"
#endif
;

#if defined(TARGET_NUCLEO_L152RE)
GT20L16J1Y_FONT font(D4, D5, D3, D2);
#else
GT20L16J1Y_FONT font(p11, p12, p13, p10);
#endif

#define numOfCharBuffer 40
uint16_t kBuf[numOfCharBuffer];
 
void draw_string(int offset_x, int offset_y, int width)
{
    int color;
    for(int x=0; x<width*2; x++)
    {
        for(int y=0; y<8; y++)
        {
            if (font.bitmap[x] & (1<<y))
                color = 1;
            else
                color = 0;
            lcd.pixel(x%width + offset_x, y+(8*(x/width)) + offset_y, color);
        }
    }
    lcd.copy_to_lcd();
}
 
int int_compar(const uint16_t *a, const uint16_t *b)
{
    if (*a < *b)
        return (-1);
    else if (*a > *b)
        return (1);
    else
        return (0);
}
 
int conv_utf8(char* utfBuffer, uint16_t* kutenBuffer)
{
    int ret;
    uint16_t key, *index, *pBuf;
    char *uBuf;
    
    uBuf = utfBuffer;
    pBuf = kutenBuffer;
    ret = 0;
 
    while (uBuf[0] != 0) {
        if (uBuf[0] >= 0x20 && uBuf[0] < 0x80) {
            // in case of ASCII
            *pBuf++ = (uint16_t)uBuf[0];
            uBuf += 1;
            ret++;
            continue;
        }
        else if ( (uBuf[0]&0xF0) != 0xE0) {
            uBuf += 1;
            continue;
        }
        // extract valid bits of UTF-8 
        key = ((uBuf[0] & 0x000F) << 12) | ((uBuf[1] & 0x003F) << 6) | (uBuf[2] & 0x003F);
        
        // search UTF-8 code from utf8_key[] table to get index of Kuten table
        index = (uint16_t *)bsearch(&key, utf8_key, (sizeof(utf8_key) / sizeof(utf8_key[0])), sizeof(uint16_t), (int (*)(const void *, const void *))int_compar);
        if (index != 0) {
            // get Kuten code
            *pBuf = utf8_value[index - utf8_key];
        }
 
        uBuf += 3;
        pBuf++;
        ret++;
    }
    *pBuf = 0;
    
    return ret;
}
 
void draw_utf8(int offset_x, int offset_y, char *buf_u)
{
    int len = conv_utf8(buf_u, kBuf);
    int xpos = 0;
    
    for(int i = 0; i < len; i++) {
        int width = font.read_kuten(kBuf[i]);
        draw_string(xpos + offset_x, offset_y, width);
        xpos += width;
    }
}


int main() {
    unsigned short kbuf[16] = {0x93fa, 0x967b, 0x8cea, 0x955c, 0x8ea6};
     
    printf("%s\r\n", target);
    lcd.setmode(NORMAL);
    // lcd.set_font((unsigned char*) Arial_9);
    lcd.set_contrast(25);
    while (1) {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("\r\n %s!\r\n This is AQM1248A demo.", target);     
 
        wait(1);
        lcd.cls();
        draw_utf8(0, 0,  "進捗どうですか??");
        draw_utf8(0, 16, "mbedで日本語表示");
        wait(5);
        // continue;  

        // wait(1);
        lcd.cls();
        lcd.line(0, 0, lcd.width()-1, 0, 1);
        lcd.line(0, 0, lcd.width()-1, lcd.height()-1, 1);
        lcd.line(0, 0, 0, lcd.height()-1, 1);
        wait(1);
        lcd.circle(12, 32, 10, 1);
        lcd.fillcircle(24, 32, 10, 1);
        lcd.rect(36, 32, 48, 44, 1);
        lcd.fillrect(60, 32, 72, 44, 1);
        wait(1);
        lcd.print_bm(logo, 0, 0);
        // lcd.copy_to_lcd();
        lcd.printf("\r\n\r\n  %s", target);
        
        wait(12);
    }
}
