#include "mbed.h"
#include "TextLCD.h"

TextLCD     lcd( p24, p26, p27, p28, p29, p30 ); // rs, e, d0-d3

#define USE_INTR 1

I2C i2c(p9, p10);        // sda, scl
#if USE_INTR
InterruptIn orientationInt(p5);
#else
DigitalIn orientationInt(p5);
#endif
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut flash(LED4);

const int MMA7660 = 0x4c;
// define the I2C register address
const char XOUT = 0x00;
const char YOUT = 0x01;
const char ZOUT = 0x02;
const char TILT = 0x03;
const char SRST = 0x04;
const char SPCNT = 0x05;
const char INTSU = 0x06;
const char MODE = 0x07;
const char SR = 0x08;
const char PDET = 0x09;
const char PD = 0x0A;

void i2c_write(int addr, char *p, int n) {
    int i, r;
 
    i2c.start();
    r = i2c.write(addr << 1); // write mode
    for (i = 0; i < n; i++) {
        r = i2c.write((int)*p++);
    }
    i2c.stop();
    // wait(0.1);
}

int i2c_read(int addr, int reg) {
    int r;
   
    i2c.start();
    r = i2c.write(addr << 1); // set read bit
    r = i2c.write(reg);
    i2c.start();
    r = i2c.write((addr << 1) | 1); // set read bit
    r = i2c.read(0); // read the data with nack
    i2c.stop();
    return r;
}

void configureMMA7760() {
    char cmd[4];
    int r;
    
    // i2c.frequency(400000);
    // pc.printf("START\r\n");
    cmd[0] = MODE;  cmd[1] = 0x00; i2c_write(MMA7660, cmd, 2); // Standby Modes
    cmd[0] = SPCNT; cmd[1] = 0x00; i2c_write(MMA7660, cmd, 2); // No sleep count
    cmd[0] = INTSU; cmd[1] = 0x03; i2c_write(MMA7660, cmd, 2); // Configure GINT Interrupt
    cmd[0] = PDET;  cmd[1] = 0xE0; i2c_write(MMA7660, cmd, 2); // No tap detection enabled
    cmd[0] = SR;    cmd[1] = 0x34; i2c_write(MMA7660, cmd, 2); // 8 samples/s, TILT debounce filter = 2
    cmd[0] = PD;    cmd[1] = 0x00; i2c_write(MMA7660, cmd, 2); // No tap detection debounce count enabled
    cmd[0] = MODE;  cmd[1] = 0x41; i2c_write(MMA7660, cmd, 2); // No tap detection debounce count enabled
}

int se(int r) {
    if (r & 0x20) return (int)(signed char)(r | 0xe0);
    else return r & 0x1f;
}

void orientation() {
    int r;
    
    r = i2c_read(MMA7660, TILT);
    // if (r) pc.printf("read error %02x\r\n", r);
    pc.printf("orientation %02x\r\n", r);
    
    if (r & 0x40) {
        pc.printf("Alert\r\n");
        goto XYZ;
    }
    if (r & 0x80) {
        pc.printf("Shake\r\n");
    }
    if (r & 0x20) {
        pc.printf("Tap\r\n");
    }

    int PoLa = (r >> 2) & 0x07;
    int BaFro = r & 0x03;
    
    lcd.locate( 0, 0 ); 
    switch (PoLa) {
    case 1:
        pc.printf("Left\r\n");  lcd.printf( "Left " ); break;
    case 2:
        pc.printf("Right\r\n"); lcd.printf( "Right" );break;
    case 5:
        pc.printf("Down\r\n");  lcd.printf( "Down " );break;
    case 6:
        pc.printf("Up\r\n");    lcd.printf( "Up   " ); break;
    defaut:
        default: lcd.printf( "     " ); break;
    } 
    lcd.locate( 8, 0 ); 
    switch (BaFro) {
    case 1: pc.printf("Front\r\n");  lcd.printf( "Front" );break;
    case 2: pc.printf("Back\r\n");   lcd.printf( "Back " );break;
    default:  lcd.printf( "     " ); break;
    }
#if 1  
 XYZ:
    lcd.locate(0, 1);
    r = i2c_read(MMA7660, XOUT);
    if (r & 0x40) { lcd.printf("    "); }
    else { lcd.printf("%4d", se(r)); }
    
    // lcd.locate(4, 1);
    r = i2c_read(MMA7660, YOUT);
    if (r & 0x40) { lcd.printf("    "); }
    else { lcd.printf("%4d", se(r)); }
    
    // lcd.locate(8, 1);
    r = i2c_read(MMA7660, ZOUT);
    if (r & 0x40) { lcd.printf("    "); }
    else { lcd.printf("%4d", se(r)); }
#endif
}

void intr() {
    char cmd[2];
    pc.printf("int!\r\n");
    orientation();
    cmd[0] = MODE;  cmd[1] = 0x00; i2c_write(MMA7660, cmd, 2); // Standby Modes
    cmd[0] = MODE;  cmd[1] = 0x41; i2c_write(MMA7660, cmd, 2); // Standby Modes
}

int main() {
    int i;
    
    pc.baud(115200) ;
    pc.printf("MMA7760 test..\r\n") ;
  
    configureMMA7760();
        
    lcd.locate( 0, 0 );
    lcd.printf( "MMA7760: Ready" );
    wait(1);
    lcd.cls();
    // lcd.locate( 0, 0 );
    orientation();
    
#if USE_INTR
    // orientation();
    orientationInt.fall(&intr);
    i = 0;
    while (1) {
        // if (i == 0) orientation();
        flash = !flash;
        wait(0.5);
        i++;
        if (i > 10) i = 0;
    }
#else
    while (1) {
        flash = !flash;
        orientation();
        wait(5);
    }
#endif
}