#ifndef C128X64SPI_H
#define C128X64SPI_H

#include "mbed.h"

class c128x64spi {
public:
  c128x64spi(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName rs, PinName reset);
  void pixel(int x, int y, int sw = 1);
  void clr(int sw = 1);
  void hline(int x0, int x1, int y, int color = 1);
  void vline(int x, int y0, int y1, int color = 1);
  void line(int x0, int y0, int x1, int y1, int color = 1);
  void locate_x(int x);
  void locate_y(int y);
  

  void wr_cmd(int cmd);
  void wr_dat(int dat);

private: 
  unsigned char gfx_buf[8][128];
  int loc_x;
  int loc_y;
    
  SPI _spi;
  DigitalOut _cs;
  DigitalOut _rs;
  DigitalOut _reset;
};

#endif