/* ---
 aitendo C128X64SPI-12P-M with FRDM-KL25Z, KL05Z and TRAGI-ARM Writer
 
 * supports Chibimo http://q61.org/chibimo/build/
 --- */

#include "mbed.h"
#include "c128x64spi.h"

// -- for KL25Z
// c128x64spi fstn(PTD2, PTD3, PTD1, PTD0, PTD5, PTA13); // mosi, miso, sclk, cs, rs, reset
// Serial pc(USBTX, USBRX);
// -- for KL05Z
c128x64spi fstn(PTA7, PTA6, PTB0, PTA5, PTB11, PTB10); // mosi, miso, sclk, cs, rs, reset
Serial pc(USBTX, USBRX);
// -- for TORA-GI U35
// c128x64spi fstn(P0_21, P0_22, P1_15, P0_6, P0_11, P0_12); // mosi, miso, sclk, cs, rs, reset
// Serial pc(P0_19, P0_18);

#define COLOR 1
#define BG_COLOR 0

void Dragon(int x1,int y1,int x2,int y2,int lv)
{
  // pc.printf("Enter Dragon(%d,%d,%d,%d,%d)\r\n", x1, y1, x2, y2, lv);
  int h,x3,y3;
  if (x1 == x2) {
    h = abs(y1 - y2) / 2;
    if (h * lv == 0) {
      fstn.line(x1, y1, x2, y2, COLOR); //ここで(x1,y1)から(x2,y2)まで線を描く
    } else {
      if (y1 < y2) {
        x3 = x1 + h;
        y3 = y1 + h;
      } else {
        x3 = x1 - h;
        y3 = y1 - h;
      }
      Dragon(x1, y1, x3, y3, lv - 1);
      Dragon(x2, y2, x3, y3, lv - 1);
    }
  } else if (y1 == y2) {
    h = abs(x1 - x2) / 2;
    if (h * lv == 0) {
      fstn.line(x1, y1, x2, y2, COLOR);//ここで(x1,y1)から(x2,y2)まで線を描く
    } else {
      if (x1 < x2) {
        x3 = x1 + h;
        y3 = y1 - h;
      } else {
        x3 = x1 - h;
        y3 = y1 + h;
      }
      Dragon(x1,y1,x3,y3,lv - 1);
      Dragon(x2,y2,x3,y3,lv - 1);
    }
  } else {
    if (lv == 0) {
      fstn.line(x1, y1, x2, y2, COLOR);//ここで(x1,y1)から(x2,y2)まで線を描く
    } else if (x1 < x2) {
      if (y1 < y2) {
        Dragon(x1,y1,x2,y1,lv - 1);
        Dragon(x2,y2,x2,y1,lv - 1);
      } else {
        Dragon(x1,y1,x1,y2,lv - 1);
        Dragon(x2,y2,x1,y2,lv - 1);
      }
    } else {
      if (y1 < y2) {
        Dragon(x1,y1,x1,y2,lv - 1);
        Dragon(x2,y2,x1,y2,lv - 1);
      } else {
        Dragon(x1,y1,x2,y1,lv - 1);
        Dragon(x2,y2,x2,y1,lv - 1);
      }
    }
  }
  // pc.printf("Leave Dragon(%d,%d,%d,%d,%d)\r\n", x1, y1, x2, y2, lv);
}

int main() {
  int i, x, y;

  pc.baud(115200);
  // pc.printf("start\r\n");
#if 0
  for (y = 0; y < 64; y++)
    for (x = 0; x < 128; x++)
      fstn.pixel(x, y, 1);
  wait(1);    
  for (y = 0; y < 64; y++)
    for (x = 0; x < 128; x++)
      fstn.pixel(x, y, 0);
  wait(1);
  
  fstn.clr(0);
  for (x = 0; x < 64; x++)
    fstn.pixel(x, x, 1);
  wait(1);
  
  fstn.clr(0);
  fstn.hline(0, 127, 32, 1);
  wait(1);
  
  fstn.clr(0);
  fstn.vline(63, 0, 63, 1);
  wait(1);
  
  fstn.clr(0);
  fstn.line(0, 0, 127, 63, 1);
  fstn.line(127, 0, 0, 63, 1);
  wait(1);
#endif  
  // Dragon
  // while (1) 
  {
    for (i = 0; i < 12; i++) {
      // pc.printf("dragon %d\r\n", i);
      fstn.clr(BG_COLOR);
      Dragon(32, 42, 96, 42, i);
      wait(0.5);
    }
    wait(20);
  }
  
  unsigned char ph = 0; // state
  unsigned char pxdt[20]; // buffer
  unsigned char dt;
  while (1) {
    if (pc.readable()) {
      dt = pc.getc();
      switch (ph++) {
      case 0: // reset state - get locate Y
        if (dt & 0xC0) {
          ph = 0; // invalid address, reset state
        } else {
          // lcd locate Y
          y = dt >> 3;
          x = dt & 0x07;
          fstn.locate_y(y);
          x <<= 4;
        }
        break;
      case 1: // get pxdt[1]
        // delayMicroseconds(5);
        fstn.locate_x(x);
        pxdt[ph] = dt;
        break;
      case 2: case 3: case 4: case 5: case 6: case 7:
      case 8: case 9: case 10: case 11: case 12: case 13: case 14: case 15: // 
        fstn.wr_dat(pxdt[ph - 1]);
        pxdt[ph] = dt;
        break;
      case 16:
        fstn.wr_dat(pxdt[ph - 1]);
        // delayMicroseconds(5);
        fstn.wr_dat(dt);
        ph = 0;
        break;
      default:
        ph = 0;
        break;
      }
    }
  }
}
