//=================================
// microbit_switch_if_joy
//=================================
//    BLE switch interface with GROVE joystic for micro:bit
//    The MIT License (MIT)   Copyright (c) 2019 Masatomo Kojima

#include "mbed.h"
#include "MicroBit.h"
#include "ble/services/BatteryService.h"
#include "KeyboardService.h"
#include "Keyboard_types.h"
#include "HIDServiceBase.h"
#include "HIDDeviceInformationService.h"

//----------------------
//  GROVE JoyStick
//----------------------
#define JOY_ERR_THRE     0.4   // JoyStick 異常入力の閾値
#define JOY_LOW_THRE     0.35  // JoyStick 入力値の低い側の閾値
#define JOY_HIGH_THRE    0.65  // JoyStick 入力値の高い側の閾値
#define JOY_CENTER_THRE  0.90  // JoyStick の押しスイッチの閾値
enum JOY_STATUS {
    JOY_NEUTRAL = -1,
    JOY_CENTER_PRESS ,   // 中央
    JOY_YHIGH_PRESS,    // 左
    JOY_YLOW_PRESS,     // 右
    JOY_XHIGH_PRESS,    // 上
    JOY_XLOW_PRESS,     // 下
};

//----------------------
//  Keybord
//----------------------
#define MODIFY_CTRL     0x100
#define MODIFY_SHIFT    0x200
#define MODIFY_OPTION   0x400  /* option or alt */
#define MODIFY_COMMAND  0x800  /* command or Windows */

const int KEY_BS    = 8;  /* Keyboard Backspace */
const int KEY_TAB   = 9;  /* Keyboard Tab */
const int KEY_ENTER = 10; /* Keyboard Return (Enter) */
//const int KEY_ESC = 27;   /* Keyboard Escape */
const int KEY_SPACE = 32; /* Keyboard Space */

const int KEY_EQUAL    = 0x2b;                   /* = */
const int KEY_COMMA    = 0x2c;                   /* , */
const int KEY_MINUS    = 0x2d;                   /* - */
const int KEY_PIRIOD   = 0x2e;                   /* . */
const int KEY_SLASH    = 0x2f;                   /* / */
const int KEY_QUOT     = 0x40;                   /* ' */

const int KEY_PLUS     = MODIFY_SHIFT +0x2b;     /* + */
const int KEY_LT       = MODIFY_SHIFT +0x2c;     /* < */
const int KEY_UNDER    = MODIFY_SHIFT +0x2d;     /* _ */
const int KEY_GT       = MODIFY_SHIFT +0x2e;     /* > */
const int KEY_QUESTION = MODIFY_SHIFT +0x2f;     /* ? */
const int KEY_RBRACKET = MODIFY_SHIFT +0x30;     /* )  shif+0 */
const int KEY_EXCLA    = MODIFY_SHIFT +0x31;     /* !  shif+1 */
const int KEY_AT       = MODIFY_SHIFT +0x32;     /* @  shif+2 */
const int KEY_NUMBER   = MODIFY_SHIFT +0x33;     /* #  shif+3 */
const int KEY_DOLL     = MODIFY_SHIFT +0x34;     /* $  shif+4 */
const int KEY_PERCENT  = MODIFY_SHIFT +0x35;     /* %  shif+5 */
const int KEY_CARET    = MODIFY_SHIFT +0x36;     /* ^  shif+6 */
const int KEY_AMP      = MODIFY_SHIFT +0x37;     /* &  shif+7 */
const int KEY_ASTERISK = MODIFY_SHIFT +0x38;     /* *  shif+8 */
const int KEY_LBRACKET = MODIFY_SHIFT +0x39;     /* (  shif+9 */
const int KEY_DBLQUOT  = MODIFY_SHIFT +0x40;     /* " */

//----------------------
//  Setting
//----------------------
#define NUM_GROUP1         5
#define NUM_G1MEMBER       5



const int keyCodeGroup0[3] = {   // Button A, Button B, Button A&B
   'a', 
   'b', 
   MODIFY_COMMAND + 'h'       // アプリ終了
};
const int keyCodeGroup1[NUM_GROUP1][NUM_G1MEMBER] = { // 中央 左 右 上 下
    {0,           KEY_TAB,     KEY_SPACE,   0,           KEY_ENTER  },
    {KEY_HOME,    RIGHT_ARROW, LEFT_ARROW,  DOWN_ARROW,  UP_ARROW   },
    {KEY_F1,      KEY_F2,      KEY_F3,      KEY_F4,      KEY_F5},
    {MODIFY_COMMAND+'r', 0, 0, MODIFY_OPTION+DOWN_ARROW, MODIFY_OPTION+UP_ARROW},
    {KEY_ENTER,   KEY_TAB,     KEY_SPACE,   0,           0  },
};

//in "BLE_HID\Keyboad_types.h"
//enum FUNCTION_KEY {
//    KEY_F1 = 128,   /* F1 key */
//    KEY_F2,         /* F2 key */
//    KEY_F3,         /* F3 key */
//    KEY_F4,         /* F4 key */
//    KEY_F5,         /* F5 key */
//    KEY_F6,         /* F6 key */
//    KEY_F7,         /* F7 key */
//    KEY_F8,         /* F8 key */
//    KEY_F9,         /* F9 key */
//    KEY_F10,        /* F10 key */
//    KEY_F11,        /* F11 key */
//    KEY_F12,        /* F12 key */
// 
//    KEY_PRINT_SCREEN,   /* Print Screen key */
//    KEY_SCROLL_LOCK,    /* Scroll lock */
//    KEY_CAPS_LOCK,      /* caps lock */
//    KEY_NUM_LOCK,       /* num lock */
//    KEY_INSERT,         /* Insert key */
//    KEY_HOME,           /* Home key */
//    KEY_PAGE_UP,        /* Page Up key */
//    KEY_PAGE_DOWN,      /* Page Down key */
// 
//    RIGHT_ARROW,        /* Right arrow */
//    LEFT_ARROW,         /* Left arrow */
//    DOWN_ARROW,         /* Down arrow */
//    UP_ARROW,           /* Up arrow */
//};

//----------------------
//  Display
//----------------------
#define TIME_TURN_OFF          7.0   // 非表示モードに入るまでの時間 (s)
#define SETTING_DISPLAY_WAIT   1.0   // 設定モード表示時間 (s)

//----------------------
//  State
//----------------------
enum STATE {
    STATE_DESABLE_INPUT,    // 入力無効時
    STATE_SETTING,          // パラメータ設定時
    STATE_OPERATING,        // 操作時
};
//----------------------
// Disable debug messages by setting NO_DEBUG
//----------------------
#ifndef NO_DEBUG
#define DEBUG(...) printf(__VA_ARGS__)
#else
#define DEBUG(...)
#endif

//----------------------
//  BLE & HID
//----------------------
/**
 * IO capabilities of the device. During development, you most likely want "JustWorks", which means
 * no IO capabilities.
 * It is also possible to use IO_CAPS_DISPLAY_ONLY to generate and show a pincode on the serial
 * output.
 */
#ifndef HID_SECURITY_IOCAPS
#define HID_SECURITY_IOCAPS (SecurityManager::IO_CAPS_NONE)
#endif

/**
 * Security level. MITM disabled forces "Just Works". If you require MITM, HID_SECURITY_IOCAPS must
 * be at least IO_CAPS_DISPLAY_ONLY.
 */
#ifndef HID_SECURITY_REQUIRE_MITM
#define HID_SECURITY_REQUIRE_MITM false
#endif

/**
 * Initialize security manager: set callback functions and required security level
 */
void initializeSecurity(BLE &_ble);

/**
 * - Initialize auxiliary services required by the HID-over-GATT Profile.
 * - Initialize common Gap advertisement.
 *
 * Demos only have to set a custom device name and appearance, and their HID
 * service.
 */
void initializeHOGP(BLE &_ble);

enum BLE_MESSAGE {
    BLE_NO_MESSAGE,         // メッセージ無し
    BLE_CONNECTED,          // BLE接続完了
    BLE_PAIRING_SUCCESS,    // ペアリング成功
    BLE_PAIRING_FAILED,     // ペアリング失敗
};

const char bleDispChar[]={0, 'C', 'P', 'F'};
 