//=================================
//  Class KeyValueInt
//=================================
//    The MIT License (MIT)   Copyright (c) 2018 Masatomo Kojima
//
// Keys and values are stored in pairs, maximum and minimum values are set, 
// and values can be easily increased or decreased.
// キーと値をペアで記憶する。値の最大値、最小値を設定し、値の増減を容易にする。

#include "KeyValueInt.h"

/** ----------  
 * @brief   キーと値をペアで記憶する。値の最大値、最小値を設定し、値の増減を容易にする。
 * @param   *key    キー
 * @param   disp    LED表示の文字
 * @param   data    データ
 * @param   min     最小値
 * @param   max     最大値
 * @param   rotation  true:循環する false:循環しない
 */
KeyValueInt::KeyValueInt(const char *key, char disp, int data, int min, int max, bool rotation) {
    this->key = key;
    this->disp = (disp==0 ? key[0] : disp);
    this->value = data;
    this->min = min;
    this->max = max;
    this->rotation = rotation;
    set(data);
}

/** ----------  
 * @brief  最大値と最小値を考慮して、正しい範囲の値を返す
 * @param  data   データ
 */
 int KeyValueInt::range(int data){
    if (this->rotation) {
        if (data < this->min) data = this->max;
        if (data > this->max) data = this->min;
    } else {
        if (data < this->min) data = this->min;
        if (data > this->max) data = this->max;
    }
    return data;
}

/** ----------  
 * @brief  値を更新する
 * @param  data   データ
 */
int KeyValueInt::set(int data){
    this->value = range(data);
    return this->value;
}

/** ----------  
 * @brief  値を増やす
 * @param  delta   変化量(1)
 */
void KeyValueInt::inc(int delta){
    set(range(value + delta));
}

/** ----------  
 * @brief  値を減らす
 * @param  delta   変化量(1)
 */
void KeyValueInt::dec(int delta){
   set(range(value - delta));
}

