/*------------------------------------------------------------
exio.h
拡張内容
・スイッチ長押し/通常押しの区別
・秒をHH:MM表示する。
・HH:MMをLED表示する。
-------------------------------------------------------------*/
#ifndef __EXIO_H__
#define __EXIO_H__
 
#include "mbed.h"
#include "io.h"
#include "app_util.h"
#include <time.h>
#include "ble_date_time.h"
#include "common.h"

class exio : public io
{
protected:
/*単位の表示*/
    virtual void display_unit(void)
    {
        // [row6] D56-D49
        // [row7] D64-D57
        //
        //     D53 D54 D55    *  *  *
        //     D56 D57 D58       *
        //     D59 D60 D61       *
        //     D62 D63 D64       *
        //
        if(_mode == M_SCALE){ // (SCALE) G
            _row_out[6] |= 0xf0;
            _row_out[7] |= 0xf4;
            _cnt = 0;
        } else if(_mode == M_WATCHTIMER && _state == S_WATCH){ // (WATCH) .(period)
            if(_cnt < 5){
L001:
                _row_out[6] |= 0x00; // 単位表示
                _row_out[7] |= 0x20;
            } else if(_cnt < 10){
                _row_out[6] &= 0x0f; // 単位消去
                _row_out[7] &= 0x00;
            } else {
                _cnt = 0;
                goto L001;
            }
        } else if(_mode == M_WATCHTIMER && _state == S_TIMER){ // (TIME) T
            _row_out[6] |= (0x10 + 0x20 + 0x40);
            _row_out[7] |= (0x01 + 0x08 + 0x40);
            _cnt = 0;
        }
    }
    /*void display_unitT(void)
    {
        // 単位T表示
        _row_out[6] |= (0x10 + 0x20 + 0x40);
        _row_out[7] |= (0x01 + 0x08 + 0x40);
         _cnt = 0;
    }*/
protected:
/*100msec処理*/
    virtual void TickerCallback(void)
    {
        _cnt++;
        // スイッチ状態を定期的に見る
        uint8_t sw = _sw->read();
        if(sw == 1 && !_swFlag){// スイッチ押されたとき
            _counter = 0;
            _swState = None;
            _swFlag = true;

        } else if(sw == 0 && _swFlag){// スイッチ離されたとき
            _swFlag = false;
            if(_swState == None){ // スイッチ状態未決定の場合
                if(_counter >= 10){ /*1sec*/
                    _swState = LongPressed;
                    //printf("LongPressed\r\n");
                 } else {
                    _swState = Pressed;
                    //printf("Pressed\r\n");
                }
            }
        } else {
            _counter++;
            // スイッチ押された状態で1sec経過したらコールバック
            if(_swFlag && _counter >= 10 && !_callFlag){
                _callback.call();
                _callFlag = true; // 1回コールすれば用済み
            }
        }
        _lastSW = sw;
#ifdef UART_DEBUG
        //pc.printf("%d", sw);
#endif
    }
    
public:
/*コンストラクタ*/
    exio() : io(P0_15, P0_13)
    {
        _callFlag = false;
        _cnt = 0;
        _swFlag = false;
        _swState = None;
        _ticker.attach(this, &exio::TickerCallback, 0.1);
    }
    
/*スイッチ状態*/
    typedef enum {
        None = 0,
        Pressed,
        LongPressed,
    } Switch_t;
    
/*スイッチ状態の取得 ==> スーパークラスのものを上書き*/
    virtual uint8_t get_switch() 
    {
        return _swState;
    }
    
/*スイッチ状態のリセット*/
    void switch_reset(void)
    { 
        _swState = None; 
        _lastSW = 0;
    }
    
/*秒をHH:MM表示する*/
    void displaySeconds(int value)
    {
        // 4-digit convert
        // 40s->0040   100s->0140 
        int a = value / 60;
        int b = value % 60;
        value = 100 * a + b;
        display_value = value;
#ifdef UART_DEBUG
        pc.printf("[%04d]\r\n", value);
#endif
    }
    
/*HH:MMをLED表示する*/
    void displayHHMM(ble_date_time_t &dt)
    {
        // 4-digit convert
        // 10:50->1050  23:59->2359  
        int value = dt.hours * 100 + dt.minutes;
        display_value = value;
#ifdef UART_DEBUG
        pc.printf("[%04d][%d/%d/%d %02d:%02d:%02d]\r\n", 
            value, dt.year, dt.month, dt.day, dt.hours, dt.minutes, dt.seconds);
#endif
    }
    
    void attach(void (*func)(void))
    {
        _callback.attach(func);
    }
    /*template<typename T>
    void attach(T *obj, void (T::*member)(void))
    {
        _callback.attach(obj, member);
    }*/
    void CallFlagClear()
    {
        _callFlag = false;
    }
    
private:
    bool _swFlag;
    Switch_t _swState;
    uint8_t _lastSW;
    Ticker _ticker;
    int _counter;
    int _cnt;
    FunctionPointer _callback;
    bool _callFlag;
    
};

#endif /*__EXIO_H__*/
