#ifndef io_H_
#define io_H_

#include "mbed.h"
#include "common.h"

//#define UART_DEBUG

//#define PCB_VER1 // define for ver1 board (P0_26/27 -> P0_24/25) & ADC
//#define PCB_VER2
//#define PCB_VER3 // default
//#define PCB_VER4 // with HX711

//#define USE_JOYSTICK // define for using joystick as power switch in PCB_VER1

// memo of load cell / gain
// 0.9mV/kg(raw) -> 0.54V/kg(x600)
// FS=+-1.65V -> 3.06kg(FS)

// 0.9mV/kg(raw) -> 0.297V/kg(x330)
// FS=+-1.65V -> 3.06kg(FS)

//#define WEIGHT_COEFFICIENT              (8.64)
//#define WEIGHT_COEFFICIENT              (3.15)
// weight calibration on 2016/3/28 by akita11 in weight_calib150328.txt
#define WEIGHT_COEFFICIENT              (682.32) // for PCB_VER4
// 2000g = 6300

//#define DISPLAY_ZERO_SUPPRESS // leading zero suppress on display

class io {
public:
#ifdef PCB_VER4
    io(PinName CLK, PinName DAT);
#else
    io();
#endif
    ~io(); 
    int display_value; // 4-digit integer to display
    void display(float f); // set display brightness (0.0 - 1.0)

    virtual float get_weight(); // get (calibrated) weight [g]
#ifdef PCB_VER4
    virtual uint32_t get_weight_raw(); // ADC raw value of weight gauage
#else
    uint16_t get_weight_raw(); // ADC raw value of weight gauage
#endif
    virtual uint8_t get_switch(); // get switch status (1=pressed, 0=released)

    virtual void calibrate_weight(); // calibrate weight gauage
    void analog_pow(uint8_t f); // turn on/off analog power

#ifdef PCB_VER4
    uint32_t _get_adc_raw(uint8_t ch); // ADC raw value, 0x0000 - 0xffffff 
    uint32_t _adc0; // ADC value for calibrating zero point
#else
    uint16_t _get_adc_raw(uint8_t ch); // ADC raw value, 0x0000 - 0xffff 
    uint16_t _adc0; // ADC value for calibrating zero point
#endif

#ifdef PCB_VER4
    void power_save_mode(uint8_t f); // f=1 for power-save mode during sleep
#endif

 protected:
#ifdef PCB_VER4
#endif
    uint8_t _seg[4];
    float _get_adc(uint8_t ch); // ADC value, 0.0 - 1.0
#ifdef PCB_VER1
    float _get_x(); // raw value of joystick X
    float _get_y(); // raw value of joystick Y
#endif
    // belows are for internal use only
    int _display_value;
    uint8_t _col;
    uint8_t _row_out[8];
    void _set_col();
    void _set_row(uint8_t d);
    uint8_t _set_segment(uint8_t d);
    void _timer_ticker();
    DigitalOut *_sg0, *_sg1, *_sg2, *_sg3, *_sg4, *_sg5, *_sg6, *_sg7;
    DigitalOut *_sa0, *_sa1, *_sa2, *_pow;
#ifdef PCB_VER1
    AnalogIn *_jx, *_jy, *_weight;
#endif
#ifdef PCB_VER2
    char _adc_dat[4];
#endif
    PwmOut *_pwm;
#ifdef PCB_VER3
    DigitalIn *_sw;
    DigitalOut *_adc_ck;
    DigitalIn *_adc_di;
    uint8_t _fDisplaying;
#endif
#ifdef PCB_VER4
/*S------------------------------------------------------------------*/
protected:
    DigitalIn *_sw;
    virtual void display_unit(void){}
/*E------------------------------------------------------------------*/
//    DigitalOut *_adc_ck; // for software SPI
//    DigitalIn *_adc_di; // for software SPI
    DigitalOut *_reg_ps;
    DigitalOut *_adc_rate;
    uint32_t _PselSCK, _PselMISO; // for hardware SPI
    void _set_adc_ck(uint8_t f); // for hardware SPI
    void _enableSPI(uint8_t f); // for hardware SPI
    uint8_t _spi_transfer(void); // for hardware SPI
    uint8_t _fDisplaying;
    SPI _hx711; // for hardware SPI
#endif
    
};

#endif
